package ui;

import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;

import javax.swing.JFrame;

import model.FenetreModel;

public class Fenetre extends JFrame implements Observer
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private WindowPanel windowPanel;	
	private FenetreModel fenetreModel = new FenetreModel();

	
	public Fenetre()
	{
		super("Carte de France");

		setContentPane(windowPanel = new WindowPanel(this));

		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(800, 900);
		setLocationRelativeTo(null);		
		setVisible(true);
		
		// La fenetre principale s'abonne au modele
		fenetreModel.addObserver(this);
	}

	
	public FenetreModel getFenetreModel()
	{
		return fenetreModel;
	}

	public void setFenetreModel(FenetreModel fenetreModel)
	{
		this.fenetreModel = fenetreModel;
	}


	@Override
	public void update(Observable o, Object arg)
	{
		windowPanel.notifyForUpdate();
	}
}
