package ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class DrawingPanel extends JPanel

{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private final Fenetre fenetre;

	
	public DrawingPanel(Fenetre fenetre)
	{
		this.fenetre = fenetre;
	    setBackground(Color.WHITE) ;
		setPreferredSize(new Dimension(800,800)) ;		
	}

	@Override
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);

		try
		{
			Image img = ImageIO.read(new File("carte.jpg"));
			g.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), this);

		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		
		fenetre.getFenetreModel().paintSommets(g);
	}

	public void notifyForUpdate()
	{
		repaint();
	}

}
