package ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;

import javax.swing.JPanel;

import ui.buttons.ExtendButton;
import ui.buttons.LoadButton;
import ui.buttons.OptimalButton;
import ui.buttons.ResetButton;

public class ButtonsPanel extends JPanel
{

	private final Fenetre fenetre;
	private final LoadButton load;
	private final OptimalButton optimal;
	private final ExtendButton extend;
	private final ResetButton reset;

	public ButtonsPanel(Fenetre fenetre)
	{
		this.fenetre = fenetre;
		
		setSize(new Dimension(800, 100));
		setLayout(new GridLayout(1, 4));
		
		add(load = new LoadButton(fenetre));
		add(optimal = new OptimalButton(fenetre));
		add(extend = new ExtendButton(fenetre));
		add(reset = new ResetButton(fenetre));
	}
	
	
	@Override
	protected void paintComponent(Graphics g)
	{
		super.paintComponent(g);
	}
	
	public void notifyForUpdate() 
	{
		load.notifyForUpdate() ;
		optimal.notifyForUpdate() ;
		extend.notifyForUpdate() ;
		reset.notifyForUpdate() ;
	}

}
