package model;

import geocoder.GeoLocation;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

public class GenererLesSommets
{
	/**
	 * Tableau de Sommet
	 */
	private ArrayList<Sommet> villesSommets = new ArrayList<Sommet>();
	/**
	 * Nom du fichier
	 */
	private String nomFichier;


	public GenererLesSommets(String nom)
	{
		this.nomFichier = nom;
	}
	
	
	public ArrayList<Sommet> getSommets()
	{
		return villesSommets;
	}

	/**
	 * methode pour lire un fichier et remplir le tableau de Sommet
	 */
	public void lireEtGenererSommet()
	{
		File fichier = new File(nomFichier);
		Scanner lecteur = null;

		try
		{
			lecteur = new Scanner(fichier);
		}
		catch (FileNotFoundException e1)
		{
			e1.printStackTrace();
			System.exit(1);
		}
		String nomVille;

		while (lecteur.hasNext())
		{
			nomVille = lecteur.nextLine();

			GeoLocation geoLocation;
			try
			{
				geoLocation = new GeoLocation(nomVille);

				double latitude = geoLocation.getLatitude();
				double longitude = geoLocation.getLongitude();
				
			
				/**on a besoin des coordonées d'un point dans la base (x,y) de pixels*/
				double latitudeo =   -5.518799;           // ici les coordonnées gps du coin en haut à gauche de la fenêtre 
				double longitudeo = 50.750359; 
				double latitude1 =  5.6781;            // ici les coordonées gps du coin en bas à gauche de la fenêtre
				double longitude1 =  41.738528;
				
				double x = (latitudeo -latitude)/(latitude1 - latitudeo) * 800;  // j'obtiens les coordonnées dans la base de pixels  
				double y = (longitudeo-longitude)/(longitude1-longitudeo) * 900; // de cette façon on peut placer les points où on veut
				
				
				villesSommets.add(new Sommet(x, y, nomVille));
			}
			catch (IOException e)
			{
				e.printStackTrace();
				System.exit(1);
			}
		}
	}

	@Override
	public String toString()
	{
		return villesSommets.toString();
		
//		une autre méthode
//		String s = "";
//		for (Sommet som : villesSommets)
//		{
//			s += som.toString();
//		}
//		return s;		
	}

	public static void main(String[] args)
	{
		GenererLesSommets g = new GenererLesSommets("cities.txt");
		g.lireEtGenererSommet();
		System.out.println(g.toString());
	}
}
