package model;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Observable;

public class FenetreModel extends Observable
{
	private ArrayList<Sommet> editedSommets = new ArrayList<Sommet>();
	private Color currentColor = Color.BLUE;

	// private Sommet currentSommet = null; //a voir si c utile
	// private Sommet selectedSommet = null; //a voir si c utile
	// private boolean modified = false; //a voir si c utile

	public ArrayList<Sommet> getEditedSommets()
	{
		return editedSommets;
	}

	public void setEditedSommets(ArrayList<Sommet> editedSommets)
	{
		this.editedSommets = editedSommets;
		/* @TODO update */
	}

	public final void loadEditedSommets()
	{
		GenererLesSommets gs = new GenererLesSommets("cities.txt");
		// Lecture du fichier cities.txt et génération des sommets
		gs.lireEtGenererSommet();
		// résultat sauvegarder dans editedSommets
		editedSommets = gs.getSommets();
		setChanged();
		notifyObservers();
	}

	public final void paintSommets(Graphics g)
	{
		for (Sommet s : editedSommets)
		{
			s.paint(g, currentColor);
		}
		clearChanged();

		// if (selectedSegment != null)
		// selectedSegment.paint(g, true, false);
		//
		// if (currentSegment != null)
		// currentSegment.paint(g, false, true);
	}
}