package geocoder;

import java.io.*;
import java.net.*;

public class GeoLocation
{
	private final double latitude;
	private final double longitude;

	public final double getLatitude()
	{
		return latitude;
	}

	public final double getLongitude()
	{
		return longitude;
	}

	public GeoLocation(String address) throws IOException
	{
		String addressUTF8 = URLEncoder.encode(address, "UTF-8");
		URL url = new URL("http://maps.google.com/maps/geo?q=" + addressUTF8
				+ "&output=csv");
		InputStream inputStream = url.openStream();
		InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
		BufferedReader in = new BufferedReader(inputStreamReader);

		String line = in.readLine();

		if (Integer.parseInt(line.substring(0, 3)) == 200)
		{

			// Format: 200,6,42.730070,-73.690570
			// 200 means OK
			// 6 is the precision
			// then latitude and longitude
			String[] splitted = line.split(",");

			latitude = Double.parseDouble(splitted[2]);
			longitude = Double.parseDouble(splitted[3]);

			return;
		}

		latitude = longitude = 0.0;

		throw new IOException("Bad GeoLocation Request: " + "\"" + address
				+ "\"\n" + "Answer: " + line);
	}
}