
#ifndef NR_Mouse_OIS_H
#define NR_Mouse_OIS_H
#pragma once


#include "NR_MouseInput.h"

//OIS:
#include "OISMouse.h"


namespace netrush	//NetRush context
{
	class MouseListener_OIS;

	/** Mouse inputs using OIS.
		This class shouldn't be used directly by NetRush api user application.
		Use KeyboardInput interface instead.
	*/
	class NETRUSH_SYSTEM_API Mouse_OIS : public MouseInput	
	{
	private:

		/// OIS Mouse input interface
		OIS::Mouse* m_MouseData;

		/// Listener that get events :
		MouseListener_OIS* m_MouseListener;

			
	protected:
	
	
	public:


		/** Update Mouse state.
		*/
		void updateInput();

		/** Mouse initialization.
		*/
		void initializeInput();

		/** Release Mouse.
		*/
		void releaseInput();

		/** Set the screen size.
		*/
		void setScreenSize(int width, int height);


		/** Constructor.
		*/
		Mouse_OIS();	
		
		/** Destructor.
		*/
		~Mouse_OIS();	

		
	
	};

}

#endif	//NR_Mouse_OIS_H