#include <iostream>

#include "NR_InputManager.h"
#include "NR_Mouse_OIS.h"
#include "NR_Config.h"

//OIS
#include "OISInputManager.h"
#include "OISException.h"
#include "OISMouse.h"
#include "OISEvents.h"



namespace netrush	//NetRush context
{

	/** Used to retrieve input events from OIS...
	*/
	class MouseListener_OIS : public OIS::MouseListener
	{
	private :

		Mouse_OIS* mouse;
		
		void updatePosition( const OIS::MouseEvent &arg )
		{
			NR_ASSERT_NOT_NULL( mouse );

			MousePos m_Move=mouse->getMove();
			m_Move.x += arg.state.X.rel;
			m_Move.y += arg.state.Y.rel;
			m_Move.z += arg.state.Z.rel;
			mouse->setMove(m_Move);

			MousePos screenPos;
			screenPos.x = arg.state.X.abs;
			screenPos.y = arg.state.Y.abs;
			screenPos.z = arg.state.Z.abs;
			mouse->setScreenPosition(screenPos);

		}


	public:

		bool mouseMoved( const OIS::MouseEvent &arg ) 
		{
			updatePosition( arg );
			return true;
		}
		bool mousePressed( const OIS::MouseEvent &arg, OIS::MouseButtonID id ) 
		{
			NR_ASSERT_NOT_NULL( mouse );
			updatePosition( arg );
			mouse->setButtonState(static_cast<MouseButton>(id),KEY_IS_DOWN);
			return true;
		}
		bool mouseReleased( const OIS::MouseEvent &arg, OIS::MouseButtonID id ) 
		{
			NR_ASSERT_NOT_NULL( mouse );
			updatePosition( arg );
			mouse->setButtonState(static_cast<MouseButton>(id),KEY_IS_UP);
			return true;
		}

		
		MouseListener_OIS(Mouse_OIS* mouse_to_listen)
		{
			NR_ASSERT( mouse_to_listen != nullptr , "Tried to listen to a null mouse!" );
			mouse=mouse_to_listen;
		}

	};


	Mouse_OIS::Mouse_OIS() : m_MouseData(nullptr)//MouseInput constructor
	{
		m_MouseListener = new MouseListener_OIS(this);

		setScreenSize(0,0);		
	}

	
	Mouse_OIS::~Mouse_OIS()//MouseInput destructor
	{
		NR_ASSERT( m_MouseListener != nullptr , "Tried to destroy an unitialized mouse!" );
		delete 	m_MouseListener;	
	
	}

	
	/*
		Mouse initialization.
		Return false if failed.
	*/
	void Mouse_OIS::initializeInput()
	{
		//Create OIS Mouse :
		try
		{
			OIS::InputManager* inputManager =  InputManager::instance().m_inputManager;
			NR_ASSERT( inputManager != nullptr , "Input manager is not initialized!");
			m_MouseData = static_cast<OIS::Mouse*>(inputManager->createInputObject( OIS::OISMouse, true ));
			
			//Register it's listener:
			m_MouseData->setEventCallback(m_MouseListener);

			// set the screen size to the current screen resolution
			setScreenSize( config::graphics::screen_width, config::graphics::screen_height );

		}
		catch (OIS::Exception& e)
		{
			//Mouse initialization failed!
			NR_EXCEPTION << "Problem on Mouse initialization! : " << e.what(); 

		}
		
		ready=true;
		
	}

	/*
		Update Mouse state.
	*/
	void Mouse_OIS::updateInput()
	{
		NR_ASSERT( m_MouseData != nullptr , "Tried to update an uninitialized mouse!" );
		
		
		// reset the mouse state before updating (but not the absolute position)
		resetMove();
		resetButtonState();

		//Update OIS data :
		try
		{
			m_MouseData->capture(); //this will call events in MouseListener_OIS that will update m_ButtonState, screenPos and move
		}
		catch (OIS::Exception* e)
		{
			//Problem with the Mouse!
			NR_EXCEPTION << "Problem on Mouse capture! : " << e->eText;
		}

		
	}


	/*
		Release Mouse.
		Return false if failed.
	*/
	void Mouse_OIS::releaseInput()
	{
		//Release OIS Mouse :

		try
		{
			OIS::InputManager* inputManager =  InputManager::instance().m_inputManager;
			NR_ASSERT( inputManager != nullptr , "Input manager is not initialized!" );
			inputManager->destroyInputObject(m_MouseData);
		}
		catch (OIS::Exception* e)
		{

			//Mouse release failed!
			NR_EXCEPTION << "Problem on Mouse release! : " << e->eText; 

		}
		m_MouseData=nullptr;
				
		ready=false;
		
	}

	//Set the screen size
	void Mouse_OIS::setScreenSize(int width, int height)
	{
		if( m_MouseData != nullptr )
		{
			m_MouseData->getMouseState().width=width;
			m_MouseData->getMouseState().height=height;
		}
	}
	

	
	
}// namespace NetRush