
#ifndef NR_Keyboard_OIS_H
#define NR_Keyboard_OIS_H
#pragma once



#include "NR_System_Common.h"	//Use NetRush System common defines

#include "NR_KeyboardInput.h"

//OIS:
#include "OISKeyboard.h"



namespace netrush	//NetRush context
{
	class KeyboardListener_OIS;

	/**	Keyboard inputs using OIS.
		This class shouldn't be used directly by NetRush API user application.
		Use KeyboardInput interface instead.
	*/
	class NETRUSH_SYSTEM_API Keyboard_OIS : public KeyboardInput	
	{
			
	public:


		/** Update Keyboard state.
		*/
		void updateInput();

		/** Keyboard initialization.
		*/
		void initializeInput();

		/** Release Keyboard.
		*/
		void releaseInput();

		/** Convert a key to a string value.
			@param key Key to convert.
			@return std::string value of the key.
		*/
		const std::string& keyToString (KeyCode key);

		/** Constructor.
		*/
		Keyboard_OIS();	
		
		/** Destructor.
		*/
		~Keyboard_OIS();
	private:

		///OIS Keyboard input interface
		OIS::Keyboard* m_KeyboardData;

		///Listener that get events :
		KeyboardListener_OIS* m_KeyboardListener;


	};

}

#endif	//NRS_Keyboard_OIS_H