#include "NR_InputManager.h"
#include "NR_Keyboard_OIS.h"

//OIS
#include "OISInputManager.h"
#include "OISException.h"
#include "OISKeyboard.h"
#include "OISEvents.h"

#include <iostream>


namespace netrush	//NetRush context
{

	/** Used to retrieve input events from OIS...
	*/
	class KeyboardListener_OIS : public OIS::KeyListener
	{
	private :

		Keyboard_OIS* m_Keyboard;

	public:

		bool keyPressed( const OIS::KeyEvent &arg ) 
		{
			m_Keyboard->setKeyState(static_cast<KeyCode>(arg.key),KEY_IS_DOWN,arg.text);
			return true;
		}

		bool keyReleased( const OIS::KeyEvent &arg ) 
		{
			m_Keyboard->setKeyState(static_cast<KeyCode>(arg.key),KEY_IS_UP);
			return true;
		}

		KeyboardListener_OIS(Keyboard_OIS* keyboard_to_listen)
		{
			NR_ASSERT( keyboard_to_listen != nullptr , "Tried to listen to a null keyboard!" );
			m_Keyboard=keyboard_to_listen;
		}

	};


	Keyboard_OIS::Keyboard_OIS():
		m_KeyboardData(nullptr)//KeyboardInput constructor
	{
		m_KeyboardListener = new KeyboardListener_OIS(this);
	}

	
	Keyboard_OIS::~Keyboard_OIS()//KeyboardInput destructor
	{
		NR_ASSERT( m_KeyboardListener != nullptr , "Tried to destroy an uninitialized keyboard!" );
		delete 	m_KeyboardListener;	
	}

	
	/*
		Keyboard initialization.
		Return false if failed.
	*/
	void Keyboard_OIS::initializeInput()
	{
		//Create OIS Keyboard :
		try
		{
			OIS::InputManager* inputManager =  InputManager::instance().m_inputManager;
			NR_ASSERT( inputManager != nullptr , "Input manager has not been initialized!" );
			m_KeyboardData = static_cast<OIS::Keyboard*>(inputManager->createInputObject( OIS::OISKeyboard, true ));
			
			//We need UNICODE characters translation : 
			m_KeyboardData->setTextTranslation(OIS::Keyboard::Unicode);
			
			//Register it's listener:
			m_KeyboardData->setEventCallback(m_KeyboardListener);

		}
		catch (OIS::Exception& e)
		{
			//Keyboard initialization failed!
			NR_EXCEPTION << "Failed on keyboard initialization! : " <<  e.what(); 
		}
		
		ready=true;
		
	}

	/*
		Update Keyboard state.
	*/
	void Keyboard_OIS::updateInput()
	{
		NR_ASSERT( m_KeyboardData != nullptr , "Tried to update an uninitialized keyboard!" );

		//Clean stringKeys
		resetStringKeys();

		//We clean previously released keys and maintain hold keys:
		for(int i=0;i<256;++i)
		{
			if(m_KeyboardState[i] == KEY_IS_UP)m_KeyboardState[i]=KEY_IS_NOT_USED;
			else if(m_KeyboardState[i] == KEY_IS_DOWN)m_KeyboardState[i]=KEY_IS_HOLD;
		}	
		
		//Update OIS data :
		try
		{
			m_KeyboardData->capture();//this will call events in KeyboardListener_OIS that will update m_KeyboardState
		}
		catch (OIS::Exception* e)
		{
			//Problem with the keyboard!
			NR_EXCEPTION << "Failed on keyboard capture! : " << e->eText;
			
		}
		
	}


	/*
		Release Keyboard.
		Return false if failed.
	*/
	void Keyboard_OIS::releaseInput()
	{
		//Release OIS Keyboard :

		try
		{
			OIS::InputManager* inputManager =  InputManager::instance().m_inputManager;
			NR_ASSERT( inputManager != nullptr , "Input manager not initialized!" );
			inputManager->destroyInputObject(m_KeyboardData);
		}
		catch (OIS::Exception* e)
		{

			//Keyboard release failed!
			NR_EXCEPTION << "Failed on keyboard release! : " << e->eText; 
		}
		m_KeyboardData=nullptr;
				
		ready=false;
		
	}

	//Convert a key to a string value
	const std::string& Keyboard_OIS::keyToString(KeyCode key) 
	{
		NR_ASSERT( m_KeyboardData != nullptr , "Tried to use the keyboard unitilized!" );
		return m_KeyboardData->getAsString(static_cast<OIS::KeyCode>(key));
	}
	

	
	
}// namespace NetRush