
#ifndef NR_InputObject_H
#define NR_InputObject_H
#pragma once



#include "NR_System_Common.h"	


namespace netrush	//NetRush context
{

	class InputManager;

	/*
		State of a key.
	*/
	enum KeyState
	{
		KEY_IS_NOT_USED	=	0,		//The key is not used
		KEY_IS_DOWN		=	1,		//The key has just been pressed
		KEY_IS_HOLD		=	2,		//The key is hold down
		KEY_IS_UP		=	3,		//The key is released 
		
	};


	/*
		A key or mouse button and a state
	*/
	struct InputState
	{
		unsigned short input;
		KeyState state;
		
	};


	/** Abstract class for common Inputs interface.
		@remark Input objects are managed by InputManager.
	*/			
	class NETRUSH_SYSTEM_API InputObject 
	{
	private:

		/** Update input state.
		@remark Input type specific.
		*/
		virtual void updateInput()=0;

		/** Input initialization.
			@remark Input type specific.
			@return false if failed.
		*/
		virtual void initializeInput()=0;

		/** Release input.
			@remark Input type specific.
			@return false if failed.
		*/
		virtual void releaseInput()=0;
	
		///Managed by InputManager
		friend class InputManager;


	protected:
	
		///True if initialized with success and ready to be used.
		bool ready;

	public:

		///True if initialized with success and ready to be used.
		bool isReady(){return ready;};

		/** Reset data of the input.
		*/
		virtual void resetState()=0;
	
		/** Constructor.
		*/
		InputObject():ready(false){};	
		
		/** Destructor.
		*/
		virtual ~InputObject(){};	

	
	};

}

#endif	//NR_InputObject_H