
#ifndef NR_InputManager_H
#define NR_InputManager_H
#pragma once



#include "NR_System_Common.h"	//Use NetRush System common defines

#include "GC_Singleton.h"

#include "NR_MouseInput.h"
#include "NR_KeyboardInput.h"
#include "NR_Task_InputUpdate.h"

namespace OIS
{
	class InputManager;
}

namespace netrush	//NetRush context
{
	
	class MouseInput;
	class KeyboardInput;

	/** Manage inputs (Mouse and Keyboard).
	*/
	class NETRUSH_SYSTEM_API InputManager : public gcore::Singleton<InputManager>	
	{

		public:
	
		/// Mouse input data.
		MouseInput& mouse() const { NR_ASSERT_NOT_NULL( m_Mouse ); return *m_Mouse;};

		/// Keyboard input data.
		KeyboardInput& keyboard() const { NR_ASSERT_NOT_NULL( m_Keyboard ); return *m_Keyboard;};
		

		///True if all inputs initialized with success and ready to be used.
		bool isReady() const {return m_Ready;};

		/// True if the inputs are ready AND updated.
		bool isActive() const;

		/** Start acquiring inputs state and sending events using mapping definitions.
			This will initialize inputs and launch input management tasks.
		*/
		void start(WindowHandle wHandle, gcore::TaskManager& taskManager );

		/** Stop acquiring inputs state and sending events using mapping definitions.
			This will kill input management tasks and release inputs.
		*/
		void stop();

		/** Pause acquiring inputs state and sending events using mapping definitions.
			This will just pause input management tasks.
		*/
		void pause();

		/** Resume acquiring inputs state and sending events using mapping definitions.
			This will just resume input management tasks.
		*/
		void resume();


		/** Constructor.
		*/
		InputManager();	
		
		/** Destructor.
		*/
		~InputManager();

	private:

		/// OIS Input Manager.
		OIS::InputManager* m_inputManager;

		/// Handle to the window to get inputs from.
		WindowHandle m_WindowHandle;

		/// True if all inputs initialized with success and ready to be used.
		bool m_Ready;

		/// Mouse input data
		MouseInput* m_Mouse;
	
		/// Keyboard input data
		KeyboardInput* m_Keyboard;

		/// Update input state.
		Task_InputUpdate* m_taskInputUpdate;
				
		/// Task_InputUpdate will call UpdateInputs each cycle.
		friend class Task_InputUpdate;
		
		/// OIS specific : inputs from OIS need access to it's InputManager
		friend class Keyboard_OIS;
		/// OIS specific : inputs from OIS need access to it's InputManager
		friend class Mouse_OIS;
		
		/** Initialize inputs.
		*/
		void initializeInputs(gcore::TaskManager& taskManager);

		/** Release inputs.
		*/
		void releaseInputs();

		/** Update inputs state.
			@remark This function should be called very often,
			once per main loop cycle.
		*/
		void updateInputs();

		
	protected:
	
	
	
	
	};

}

#endif	//NRS_InputManager_H