package web;

import bean.GestionAgence;
import java.io.IOException;
import java.text.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;
/**
 * Servlet implementation class Application
 */
public class Application extends HttpServlet 
{
	private static final long serialVersionUID = 1L;
	
	
	// paramètres d'instance
	private String urlErreurs = null;
	private ArrayList erreursInitialisation = new ArrayList<String>();
	//+ Paramètres de la servlet dans web.xml
	private String[] paramètres = { "urlListAgences", "urlEditAgence", 
									  "urlListEmployes", "urlEditEmploye",
									  "urlListClients", "urlEditClient", 
									  "urlListComptes", "urlEditCompte",
									  "urlErreurs" };
	private Map params = new HashMap<String, String>();
	
	
	// init,initialisation de la servlet
	@SuppressWarnings("unchecked")
	public void init() throws ServletException 
	{
		// on récupère les paramètres d'initialisation de la servlet
		ServletConfig config = getServletConfig();
		
		// on traite les autres paramètres d'initialisation
		String valeur = null;
		
		//+ Boucle qui vérifie la liste des paramètres de la servlet
		for (int i = 0; i < paramètres.length; i++) {
			// valeur du paramètre
			valeur = config.getInitParameter(paramètres[i]);
			// paramètre présent ?
			if (valeur == null) {
				// on note l'erreur
				erreursInitialisation.add("Le paramètre [" + paramètres[i]+ "] n'a pas été initialisé");
			} 
			else {
				// on mémorise la valeur du paramètre
				params.put(paramètres[i], valeur);
			}
		}
		
		// l'url de la vue [erreurs] a un traitement particulier
		urlErreurs = config.getInitParameter("urlErreurs");
		if (urlErreurs == null)
		throw new ServletException(
		"Le paramètre [urlErreurs] n'a pas été initialisé");
	}
	

	protected void doGet(HttpServletRequest request, HttpServletResponse response) 
	throws ServletException, IOException 
	{
		//+ Vérifie l'initialisation
		if(erreursInitialisation.size() !=0)
		{
			request.setAttribute("erreurs", erreursInitialisation);
			getServletContext().getRequestDispatcher(urlErreurs).forward(request, response);
			return;
		}
		
		// on récupère la méthode d'envoi de la requête
		String methode = request.getMethod().toLowerCase();
		
		// on récupère l'action à exécuter
		String action = request.getPathInfo();
		
		if(action == null)
		{
			action = "/listAgences";
		}
		
		// exécution action
		if(methode.equals("get") && action.equals("/listAgences"))
		{
			//+ On affiche la liste des agences en appelant : 
			doListAgences(request, response);
			return;
		}
		if(methode.equals("get") && action.equals("/deleteAgence"))
		{
			//+ Supression d'une agence
			doDeleteAgence(request, response);
			return;
		}
		if(methode.equals("get") && action.equals("/editAgence"))
		{
			//+ On envoi le formualaire pour éditer une agence
			doEditAgence(request, response);
			return;
		}
		if (methode.equals("post") && action.equals("/validateAgence"))
		{
			//+ Validation du formulaire d'édition
			doValidateAgence(request, response);
			return;
		}
		
		if(methode.equals("get") && action.equals("/listEmployes"))
		{
			doListClients(request, response);
			return;
		}
		if(methode.equals("get") && action.equals("/editEmploye"))
		{
			
		}
		
		doListAgences(request, response);
		
	}
	
	//+ Affichage de la liste des agences
	private void doListAgences(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		//+ Récupérer la listes des Agences disponibles
                GestionAgence agences = new GestionAgence();
                request.setAttribute("Bonjour", agences.bonjour());
                request.setAttribute("agences", agences.gelLesAgences().getListAgences());
                    
		//+ On affiche la vue list.jsp
		getServletContext().getRequestDispatcher((String)params.get("urlListAgences")).forward(request, response);
	}
	
	private void doDeleteAgence(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		// on récupère l'id de l'agence, via un permetre et non un attribut
		//+ getParameter = requête du client
		//+ getAttribute = objet de l'application
		int id = Integer.parseInt(request.getParameter("id"));
		
		//+ Méthodes pour supprimer l'agence
		
		//+ Redirection vers la liste des agences
		response.sendRedirect("listAgences");
	}
	
	private void doEditAgence(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		// on récupère l'id de l'agence, via un permetre et non un attribut
		//+ getParameter = requête du client
		//+ getAttribute = objet de l'application
		int id = Integer.parseInt(request.getParameter("id"));
		
		//+ si l'id != -1 c'est une modification agence
		if(id != -1)
		{
			//+ Récupération de l'agence à modifier
		}
		else
		{
			//+ On ajoute une personne
		}
		//+ on met les attributs
		
		//+ On envoi la requête vers la page JSP
		getServletContext().getRequestDispatcher((String)params.get("urlEditAgence")).forward(request, response);
		
	}
	private void doValidateAgence(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
	}
	
	private void doListEmployes(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		
	}
	private void doDeleteEmploye(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		
	}
	private void doEditEmploye(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		
	}
	
	
	private void doListClients(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		
	}
	private void doDeleteClient(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		
	}
	private void doEditClient(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		
	}
	
	
	private void doListComptes(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		
	}
	private void doDeleteCompte(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		
	}
	private void doEditCompte(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException 
	{
		
	}

	
	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) 
	throws ServletException, IOException 
	{
		doGet(request, response);
	}
}