package com.bnpp.xstream.serializer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import xstream_reference.Activator;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.io.xml.DomDriver;

public class XMLManager {
	private static XStream xstream = null;

	public RootXML read(String filename) throws IOException {
		FileInputStream fis;

		fis = new FileInputStream(filename);
		RootXML ret = (RootXML) xstream.fromXML(fis);
		fis.close();
		return ret;

	}

	public void write(String filename, RootXML root) {
		try {
		xstream = new XStream(new DomDriver());
		xstream.setClassLoader(Activator.getDefault().getDynamicClassLoader());
		xstream.processAnnotations(RootXML.class);
		List<Object> nodes = root.getSubNodes();
		if (nodes != null)
			for (Object o : nodes) {
				xstream.processAnnotations(o.getClass());
			}
		String xml = xstream.toXML(root);
		
			File file = new File(filename);
			FileWriter fw = new FileWriter(file);
			fw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");// $NON-NLS-1$
			fw.write(xml);
			fw.close();
		} catch (Exception e) {
			MessageDialog.openError(new Shell(), "Error in write",
			e.getMessage());
		}
	}
}
