package com.bnpp.xstream.serializer;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import xstream_reference.Activator;

import com.bnpp.xstream.intf.IObjectFactory;

public class WriteAction implements IObjectActionDelegate {

	private Shell shell;

	/**
	 * Constructor for Action1.
	 */
	public WriteAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		shell = targetPart.getSite().getShell();
	}

	public static final String FILENAME = "C:\\workspaces\\osgi\\nodes.xml";

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		IObjectFactory factory = Activator.getDefault().getFactory();
		RootXML root = new RootXML();
		root.addNode(factory.create("client"));
		root.addNode(factory.create("client"));
		root.addNode(factory.create("command"));
		XMLManager manager = new XMLManager();
		manager.write(FILENAME, root);
		MessageDialog.openInformation(
			shell,
			"xstream",
			"WriteAction was executed.");
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

}
