package com.bnpp.xstream.serializer;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import xstream_reference.Activator;

import com.bnpp.xstream.intf.IObjectFactory;

public class LoadAction implements IObjectActionDelegate {

	private Shell shell;

	/**
	 * Constructor for Action1.
	 */
	public LoadAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		shell = targetPart.getSite().getShell();
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		IObjectFactory factory = Activator.getDefault().getFactory();
		RootXML root;
		XMLManager manager = new XMLManager();
		try {
			root = manager.read(WriteAction.FILENAME);
			if (root != null) {
				MessageDialog.openInformation(shell, "xstream",
						"LoadAction was executed. nb nodes = "
								+ (root.getSubNodes() != null ? root
										.getSubNodes().size() : "NULL"));
			} else
				MessageDialog.openError(shell, "xstream",
						"LoadAction was executed.");
		} catch (Exception ex) {
			MessageDialog.openError(shell, "xstream", ex.getMessage());
		}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

}
