import pygtk,os; pygtk.require('2.0')
import gtk

ICONS=dict([(name,gtk.image_new_from_file(name)) for name in os.listdir('./') if name[-4:]=='.ico'])

#In order to create a custom cellRenderer which displays a pixbux, can be edited by display a combobox which entries are themselves pixbufs
# I guess we should first learn how to create a custom ComboBox
# Then subclass gtk.CellRendererPixbuf, and...

class Window(gtk.Window):
    def __init__(s):
        gtk.Window.__init__(s)
        s.set_title('Basic TreeView Example')
        s.set_size_request(200,200)
        s.connect('delete_event', s.quit)
        s.cb = ComboBox()
        s.add(s.cb)
        s.show_all()
    def quit(s,w,e,data=None):
        gtk.main_quit()
    def main(s):
        gtk.main()

class ListStore(gtk.ListStore):
    def __init__(s):
        gtk.ListStore.__init__(s,str)
        for name in ICONS:
            s.append([name])

class ComboBox(gtk.ComboBox):
    def __init__(s):
        s.model = ListStore()
        gtk.ComboBox.__init__(s,s.model)
        s.cell  = gtk.CellRendererPixbuf()
        s.pack_start(s.cell,True)
        s.set_cell_data_func(s.cell, s.data_func)
        s.connect('changed',s.on_changed)
    def data_func(s, celllayout, cell, model, iter, data=None):
        pb = ICONS[model.get_value(iter,0)].get_pixbuf()
        cell.set_property('pixbuf',pb)
    def on_changed(s, cb, *data):
        print s.get_active_text()#s.model[s.get_active()]

class TreeView(gtk.TreeView):
    def __init__(s,model):
        gtk.TreeView.__init__(s,model)
        s.model         = model
    def data_pixbuf_func(s,col,cell,model,iter,data=None):
        icon_name = model.get_value(iter,1)
        cell.set_property('pixbuf', ICONS[icon_name].get_pixbuf())
    def on_edited(s, cell, path, new_text, *data):
        print 'edited',new_text, type(new_text)
        model,iter=s.get_selection().get_selected()
        model.set_value(iter,0, int(new_text))#str(int(s.spin_adj.get_value())))
        model.append([1,'pencil.ico','note'])
    def on_txt_edited(s, cell, path, new_text, *data):
        print 'txt edited'
        model,iter=s.get_selection().get_selected()
        if data[0]==2: model.remove(iter)
        else : model.set_value(iter,data[0], new_text)

if __name__=='__main__':
    app=Window()
    app.main()
