#include "DS3231.h"
#include "ephemeride.h"
#include "affichage.h"

#include <Arduino.h>
#include <math.h>

double latitude_nord = 45.6590039;
double longitude_ouest = -5.278757777777778;
double lever, meridien, coucher;

const char* affichdate;
const char* affichHeure;


/******************************************************/ 
void calculerEphemeride(int jour, int mois, int annee,
                        double longitude_ouest, double latitude_nord,
                        double *lever, double *meridien, double *coucher)
{
  int nbjours;
  const double radians = M_PI / 180.0;
  double d, x, sinlat, coslat;
 
  if (annee > 2000) annee -= 2000;
  nbjours = (annee * 365) + ((annee + 3) >> 2) + jour - 1;
  switch (mois)
  {
    case  2: nbjours +=  31; break;
    case  3: nbjours +=  59; break;
    case  4: nbjours +=  90; break;
    case  5: nbjours += 120; break;
    case  6: nbjours += 151; break;
    case  7: nbjours += 181; break;
    case  8: nbjours += 212; break;
    case  9: nbjours += 243; break;
    case 10: nbjours += 273; break;
    case 11: nbjours += 304; break;
    case 12: nbjours += 334; break;
  }
  if ((mois > 2) && ((annee & 3) == 0)) nbjours++;
  d = nbjours;
 
  x = radians * latitude_nord;
  sinlat = sin(x);
  coslat = cos(x);
 
  calculerCentreEtVariation(longitude_ouest, sinlat, coslat, d + longitude_ouest / 360.0, meridien, &x);
  *lever = *meridien - x;
  *coucher = *meridien + x;
 
  calculerCentreEtVariation(longitude_ouest, sinlat, coslat, d + *lever, lever, &x);
  *lever -= x;
 
  calculerCentreEtVariation(longitude_ouest, sinlat, coslat, d + *coucher, coucher, &x);
  *coucher += x;
}

/***************************************************************************************************************************************/ 
static void calculerCentreEtVariation(double longitude_ouest, double sinlat, double coslat, double d, double *centre, double *variation)
{
  const double M_2PI = 2.0 * M_PI;
  const double degres = 180.0 / M_PI;
  const double radians = M_PI / 180.0;
  const double radians2 = M_PI / 90.0;
  const double m0 = 357.5291;
  const double m1 = 0.98560028;
  const double l0 = 280.4665;
  const double l1 = 0.98564736;
  const double c0 = 0.01671;
  const double c1 = degres * (2.0 * c0 - c0 * c0 * c0 / 4.0);
  const double c2 = degres * c0 * c0 * 5.0 / 4.0;
  const double c3 = degres * c0 * c0 * c0 * 13.0 / 12.0;
  const double r1 = 0.207447644182976;
  const double r2 = r1 * r1;
  const double d0 = 0.397777138139599;
  const double o0 = -0.0106463073113138;
 
  double M, C, L, R, dec, omega, x;
 
  M = radians * fmod(m0 + m1 * d, 360.0);
  C = c1 * sin(M) + c2 * sin(2.0 * M) + c3 * sin(3.0 * M);
  L = fmod(l0 + l1 * d + C, 360.0);
  x = radians2 * L;
  R = -degres * atan((r2 * sin(x)) / (1 + r2 * cos(x)));
  *centre = (C + R + longitude_ouest) / 360.0;
 
  dec = asin(d0 * sin(radians * L));
  omega = (o0 - sin(dec) * sinlat) / (cos(dec) * coslat);
  if ((omega > -1.0) && (omega < 1.0))
    *variation = acos(omega) / M_2PI;
  else
    *variation = 0.0;
}

/***************************************/ 
void afficherHeureJulienne(double d)
{
  d += 0.5;
  if (d < 0.0) d += 1.0;
  if (d > 1.0) d -= 1.0;
 
  int h = d * 24;
  d -= h / 24.0;
  int m = d * 1440;
  d -= m / 1440.0;
  int s = d * 86400 + 0.5;
 
  if (h < 10) Serial.print('0');
  Serial.print(h); Serial.print(':');
  if (m < 10) Serial.print('0');
  Serial.print(m); Serial.print(':');
  if (s < 10) Serial.print('0');
  Serial.println(s);
}

//#########################################################################################
void afficherTexte(char texte[])
{
  Serial.print(texte);
}

//#########################################################################################
void afficherDate(int jour, int mois, int annee)
{
  char texte[20];
  static String(affichdate);
  sprintf(texte, "%02d/%02d/%04d", jour, mois, annee);
  afficherTexte(texte);
  affichdate = " Date : ";
  affichdate += texte;
}

//#########################################################################################
void afficherHeure(int heure, int minute, int seconde)
{
  char texte[22];
  static String(affichHeure);
  sprintf(texte, "%02d:%02d:%02d", heure, minute, seconde);
  afficherTexte(texte);
  affichHeure = " Heure UTC: ";
  affichHeure += texte;
}

