#include "DS3231.h"
#include "ephemeride.h"
#include "affichage.h"

#include <Arduino.h>
#include <GxEPD2_BW.h>
#include <U8g2_for_Adafruit_GFX.h>

#define ENABLE_GxEPD2_display 0
#define SCREEN_WIDTH   212
#define SCREEN_HEIGHT  104
#define Large 7    // For best results use odd numbers
#define Small 3    // For best results use odd numbers
GxEPD2_BW<GxEPD2_213_BN, GxEPD2_213_BN::HEIGHT> display(GxEPD2_213_BN(/*CS=5*/ 5, /*DC=*/ 17, /*RST=*/ 16, /*BUSY=*/ 4)); 
U8G2_FOR_ADAFRUIT_GFX u8g2Fonts; 


//#########################################################################################
void InitialiseDisplay() {
  display.init(115200, true, 2, false);
  display.setRotation(1);                    // Use 1 or 3 for landscape modes
  u8g2Fonts.begin(display);                  // connect u8g2 procedures to Adafruit GFX
  u8g2Fonts.setFontMode(1);                  // use u8g2 transparent mode (this is default)
  u8g2Fonts.setFontDirection(0);             // left to right (this is default)
  u8g2Fonts.setForegroundColor(GxEPD_BLACK); // apply Adafruit GFX color
  u8g2Fonts.setBackgroundColor(GxEPD_WHITE); // apply Adafruit GFX color
  u8g2Fonts.setFont(u8g2_font_helvB10_tf);   // Explore u8g2 fonts from here: https://github.com/olikraus/u8g2/wiki/fntlistall
  display.fillScreen(GxEPD_WHITE);
  display.setFullWindow();
}

//#########################################################################################
void drawString(int x, int y, String text, alignmentType alignment) {
  int16_t  x1, y1; //the bounds of x,y and w and h of the variable 'text' in pixels.
  uint16_t w, h;
  display.setTextWrap(false);
  display.getTextBounds(text, x, y, &x1, &y1, &w, &h);
  if (alignment == RIGHT)  x = x - w;
  if (alignment == CENTER) x = x - w / 2;
  //if (alignment == LEFT) x = x + w ;
  u8g2Fonts.setCursor(x, y + h);
  u8g2Fonts.print(text);
}

//#########################################################################################
void DisplayAstronomySection(int x, int y) {
  //display.drawRect(x+5, y+85 , 220, 25, GxEPD_BLACK);
  display.drawRect(x, y+85 , 240, 25, GxEPD_BLACK);
  u8g2Fonts.setFont(u8g2_font_helvB08_tf);
  drawString(x+5,y+95, affichalarme, LEFT);
  display.display(false); // Full screen update mode
}

//#########################################################################################
void Draw_Heading_Section() {
  u8g2Fonts.setFont(u8g2_font_helvB08_tf);
  drawString(2, 1, affichdate+affichHeure, LEFT);
}

//#########################################################################################
void full_sreeen(){
  display.display(false); // Full screen update mode 
}
//#########################################################################################
void powerOff(){
 display.powerOff();  
}