
#include "DS3231.h"
#include "ephemeride.h"
#include "affichage.h"

#include "RTClib.h"
#include "driver/rtc_io.h"
#include <Wire.h>
#include <time.h>
#include <Arduino.h>

String(affichalarme);

//---------------- DS3231 ---------------------------------------
RTC_DATA_ATTR int bootCount = 0;          // Enregistre le nombre de fois où l'ESP32 s'est réveillé
RTC_DS3231 rtc; // Instance pour le RTC
DateTime alarm1Time = DateTime(0, 0, 0, 0, 0, 0);

//String(affichalarme);
const char* affichalarm ;
//String(affichmode);
const char* affichmode ;

void Init_RTC() {
 // Initialiser le RTC
  if(!rtc.begin()) {
    Serial.println("Impossible de trouver RTC !");
    Serial.flush();
    while (1) delay(10);
  }else{
      Serial.println(F("RTC = OK"));
  }  

}

void Infos_RTC(){
   DateTime maintenant = rtc.now();  // on lit la date actuelle
  // s'il y a eu déclenchement d'alarme on ajoute 1 jour à la date en cours et enlève l'alarme
  if (rtc.alarmFired(1)==true) {
    rtc.clearAlarm(1);
    maintenant = maintenant + TimeSpan(1,0,0,0); // On ajoute 1 jour à la date en cours
    Serial.println(" -Alarme réactualisée-");
  }

  /* --- Décommenter si besoin de définir l'heure du RTC ----*/
  //rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
  //rtc.adjust(DateTime(2025, 8, 22,21, 48, 00)); // Attention mettre à l'heure UTC
  /*-------------------------------------------------------------------*/
 
  rtc.disable32K();   // Désactiver la broche 32K
  rtc.writeSqwPinMode(DS3231_OFF);
  rtc.disableAlarm(2);
  
   // On calcule maintenant le jour, le mois et l'année.
  double lever, meridien, coucher;
  jour = maintenant.day();
  mois = maintenant.month();
  annee = maintenant.year();
  
  // Heure actuelle du DS3231
  heure  = maintenant.hour();
  minute = maintenant.minute();
  seconde = maintenant.second();

  char buf[9];
  sprintf(buf, "%02d:%02d:%02d", heure, minute,seconde );
  
  if(!rtc.setAlarm1(alarm1Time, DS3231_A1_Date)) {  // ce mode déclenche l'alarme lorsque la date et heure correspondantes
        Serial.println("Erreur, l'alarme n'a pas été réglée!");
   }else {
       Serial.println("Alarme réglée!"); 
      //calculerEphemeride(jour,mois,annee, 1, -5, 16, 43, 45, 39, 32); // Lat : 45.6590039 & Long : 5.278757777777778  => Lat : N 45 39 32.414 & Long : E 5 16 43
      calculerEphemeride(jour, mois, annee, longitude_ouest, latitude_nord, &lever, &meridien, &coucher);
      Serial.print("Lever : ");
      afficherHeureJulienne(lever);
      Serial.print("Meridien : ");
      afficherHeureJulienne(meridien);
      Serial.print("Coucher : ");
      afficherHeureJulienne(coucher); 
      full_sreeen();
  } 
}



//#########################################################################################
void programmerAlarme(int annee, int mois, int jour, double heureJulienne) {
 
  // on calcule l'heure, minute et seconde comme dans le code de bricoleau
  // dans sa fonction afficherHeure() en modifiant éventuellement le jour
  int h, m, s;
  double d = heureJulienne + 0.5;
   
  if (d < 0.0) {
    jour -= 1;
    d += 1.0;
  } else if (d >= 1.0) {
    jour += 1;
    d -= 1.0;
  }
 
  h = d * 24.0;
  d -= (double) h / 24.0;
  m = d * 1440.0;
  d -= (double) m / 1440.0;
  s = d * 86400.0 + 0.5;
   
  DateTime alarme(annee, mois, jour, h, m, s); // puis on fabrique un DateTime avec ces infos
  rtc.setAlarm1(alarme, DS3231_A1_Date); // qu'on utilise pour armer l'alarme1 du DS3231 en mode date+heure exacte
  //rtc.enableAlarm(DS3231_ALARM_1);
}

//#########################################################################################
void checkDate()
{
    DateTime alarm1Time = rtc.getAlarm1();
    Ds3231Alarm1Mode alarm1mode = rtc.getAlarm1Mode();
    //char alarm1Date[12] = "DD hh:mm:ss";
    alarm1Time.toString(alarm1Date);
    Serial.print("[ Alarme 1: ");
    Serial.print(alarm1Date);
    Serial.print(", Mode: ");
    switch (alarm1mode) {
      case DS3231_A1_PerSecond:
        Serial.println("PerSecond ]");
        affichmode = "Par Seconde";
        break;
      case DS3231_A1_Second:
        Serial.println("Second ]");
        affichmode = "Seconde";
        break;
      case DS3231_A1_Minute:
        Serial.println("Minute ]");
        affichmode = "Minute";
        break;
      case DS3231_A1_Hour:
        Serial.println("Hour ]");
         affichmode = "Heure";
        break;
      case DS3231_A1_Date:
        Serial.println("Date ]");
         affichmode = "Date";
        break;
      case DS3231_A1_Day:
        Serial.println("Day ]");
         affichmode = "Jour";
        break;
    }
    affichalarme = "Crepuscule le: ";
    affichalarme += alarm1Date;
    affichalarme += " - En Mode: ";
    affichalarme += affichmode;
    affichalarme +=  " ";
    Serial.print("");
}

void clearAlarmes_RTC(){ 
  // Mettre l'alarme 1, 2 à false (donc l'alarme 1, 2 ne s'est pas produite jusqu'à présent)
  // si ce n'est pas fait, cela conduit facilement à des problèmes, car les deux registres ne sont pas réinitialisés au redémarrage/recompilation.
  rtc.clearAlarm(1);
  rtc.clearAlarm(2);
}

void rtc_gpio () {
rtc_gpio_pulldown_dis(GPIO_NUM_33);
rtc_gpio_pullup_en(GPIO_NUM_33); 
}