#include "simplebackground.h"
#include <QWidget>
#include <QPainter>
#include <QBrush>
#include <QColor>

SimpleBackground::SimpleBackground(QWidget *parent) :
    QWidget(parent)
{
    this->_backgroundColor = new QColor(Qt::black);
}

SimpleBackground::~SimpleBackground()
{
    delete this->_backgroundColor;
}

QColor* SimpleBackground::backgroundColor ( )
{
    return this->_backgroundColor;
}

void SimpleBackground::setBackgroundColor ( QColor * color )
{
    this->_backgroundColor = color;
    this->update();
}

void SimpleBackground::paintEvent ( QPaintEvent * event )
{
    QPainter p(this);
    QRect rect = this->rect();

    p.fillRect( rect,
                QBrush( QColor(this->_backgroundColor->toRgb()) ));
}
