#include "dvpcolorpicker.h"
#include "ui_dvpcolorpicker.h"

#include "math.h"
#include <QApplication>
#include <QDesktopWidget>
#include <QGraphicsView>
#include <QImage>
#include <QBitmap>
#include <QGraphicsSceneMouseEvent>
#include <QColor>
#include <QPixmap>
#include <QPoint>
#include <QVector>
#include <QHash>
#include <QHashIterator>
#include <qDebug>
#include <QSpacerItem>
#include "colorpickerscene.h"
#include "simplebackground.h"
#include "colorslider.h"
using namespace std;

DvpColorPicker::DvpColorPicker(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::DvpColorPicker)
{
    ui->setupUi(this);

    this->graphicsView = new ColorPickerScene(this);
    ui->gridLayout->addWidget(this->graphicsView,0,0,4,1);

    this->colorPreview = new SimpleBackground(this);
    ui->gridLayout->addWidget(this->colorPreview,4,0,1,1);

    ui->gridLayout->setColumnMinimumWidth(2, 10);
    ui->gridLayout->addWidget(ui->verticalSlider,0,3,5,1);

    /**/
    QPixmap pix(12,12);
    QPainter p(&pix);
    p.setRenderHints(QPainter::Antialiasing);
    p.setBackgroundMode(Qt::TransparentMode);
    p.drawEllipse(1.0,1.0,10.0,10.0);
    this->graphicsView->setCursor( QCursor(pix) );

    connect(this->graphicsView, SIGNAL(color_picked(QColor*)),
            this, SLOT(mettre_a_jour_previsu(QColor*)));

    connect(ui->verticalSlider, SIGNAL(color_selected(QColor*)),
            this, SLOT(mettre_a_jour_colorpicker(QColor*)));

    this->definir_couleur_piquee( new QColor(QColor::fromHsv(100,255,255)) );
}

DvpColorPicker::~DvpColorPicker()
{
    delete this->graphicsView;
    delete this->colorPreview;
    delete ui;
}

void DvpColorPicker::definir_couleur_piquee(QColor * couleur_piquee)
{
    this->ui->verticalSlider->definir_couleur_choisie( couleur_piquee );
    this->mettre_a_jour_previsu( couleur_piquee );
}

QColor* DvpColorPicker::couleur_piquee()
{
    return this->colorPreview->backgroundColor();
}

void DvpColorPicker::mettre_a_jour_previsu(QColor * nouvelle_couleur)
{
    this->colorPreview->setBackgroundColor( nouvelle_couleur );
}

void DvpColorPicker::mettre_a_jour_colorpicker ( QColor * nouvelle_couleur )
{
    this->graphicsView->setBackgroundColor( nouvelle_couleur );
}





