#include "colorslider.h"
#include <QPaintEvent>
#include <QPainter>
#include <QLinearGradient>
#include <qDebug>
#include <QColor>

ColorSlider::ColorSlider(QWidget *parent) :
    QSlider(parent)
{
    connect(this,SIGNAL(valueChanged(int)),
            this, SLOT(on_valueChanged(int)));
    this->setMinimum(0);
    this->setMaximum(359);
    this->_currentColor = new QColor( QColor::fromHsv(0,255,255) );
    this->setCursor( Qt::ClosedHandCursor );
}

ColorSlider::~ColorSlider()
{
    //delete this->_currentColor;
}

void ColorSlider::on_valueChanged( int i )
{
    this->_currentColor->setHsv(359-i,255,255);
    emit( color_selected(this->_currentColor) );
}

QColor* ColorSlider::couleur_choisie()
{
    return this->_currentColor;
}

void ColorSlider::definir_couleur_choisie( QColor * color )
{
    this->_currentColor = color;
    this->setValue(color->hsvHue());
}

void ColorSlider::paintEvent ( QPaintEvent * ev )
{
    QPainter painter(this);
    painter.setCompositionMode(QPainter::RasterOp_NotSource);
    painter.setRenderHint(QPainter::Antialiasing);

    int Htriangle = 8;
    int Wtriangle = 6;
    QLinearGradient linearGrad2(Wtriangle/2,0.0,this->width()-Wtriangle,this->height());
    for( float i=0; i<360; i++ ){
        linearGrad2.setColorAt( i/360 , QColor::fromHsv(i,255,255) );
    }

    painter.fillRect(Wtriangle/2,0.0,this->width()-Wtriangle,this->height(), QBrush(linearGrad2));

    float x = ((359-this->value())/360.0)*this->height();

    painter.setPen(Qt::black);
    painter.drawLine(0,x-Htriangle/2,0,x+Htriangle/2);
    painter.drawLine(0,x+Htriangle/2,Wtriangle,x);
    painter.drawLine(Wtriangle,x,0,x-Htriangle/2);

    painter.drawLine(this->width(), x-Htriangle/2, this->width(), x+Htriangle/2);
    painter.drawLine(this->width(), x+Htriangle/2, this->width()-Wtriangle, x);
    painter.drawLine(this->width()-Wtriangle, x, this->width(), x-Htriangle/2);
}
