#ifndef COLORPICKERSCENE_H
#define COLORPICKERSCENE_H

#include <QGraphicsScene>
#include <QMouseEvent>
#include <QColor>
#include <QWidget>
#include "simplebackground.h"

class ColorPickerScene : public SimpleBackground
{
    Q_OBJECT
public:
    explicit ColorPickerScene(QWidget *parent = 0);
    ~ColorPickerScene();
    void ColorPickerScene::definir_taille_dechantillon(int nouvelle_taille);
    int ColorPickerScene::taille_dechantillon();

protected:
    void ColorPickerScene::paintEvent ( QPaintEvent * event );
    void ColorPickerScene::mouseReleaseEvent ( QMouseEvent * mouseEvent );
    void ColorPickerScene::mouseMoveEvent ( QMouseEvent *mouseEvent );
    QColor* ColorPickerScene::couleurMoyenne(QPixmap pixmap);
    int _taille_echantillon;

signals:
    void released(QMouseEvent *event);
    void moved(QMouseEvent *event);
    void color_picked(QColor * color);

public slots:
};

#endif // COLORPICKERSCENE_H
