#include "colorpickerscene.h"
#include <QPainter>
#include <QLinearGradient>
#include <QBrush>
#include <QColor>
#include <QGraphicsSceneMouseEvent>
#include <QWidget>
#include <QPixmap>

ColorPickerScene::ColorPickerScene(QWidget *parent) :
    SimpleBackground(parent)
{
    this->_taille_echantillon = 2;
}

ColorPickerScene::~ColorPickerScene()
{
}

void ColorPickerScene::definir_taille_dechantillon(int nouvelle_taille)
{
    this->_taille_echantillon = nouvelle_taille;
}

int ColorPickerScene::taille_dechantillon()
{
    return this->_taille_echantillon;
}

void ColorPickerScene::paintEvent ( QPaintEvent * event )
{
    QPainter p(this);
    QRect rect = this->rect();

    p.fillRect( rect,
                QBrush( QColor(this->_backgroundColor->toHsv()) ));

    p.setCompositionMode(QPainter::RasterOp_NotSource);

    QLinearGradient linearGrad2(rect.left()-0,0,rect.right(),0);
    linearGrad2.setColorAt(0, Qt::white);
    linearGrad2.setColorAt(1, Qt::transparent);
    p.fillRect(rect, QBrush(linearGrad2));

    QLinearGradient linearGrad(0,rect.top(),0,rect.bottom());
    linearGrad.setColorAt(0, Qt::transparent);
    linearGrad.setColorAt(1, Qt::black);
    p.fillRect(rect, QBrush(linearGrad));
}
void ColorPickerScene::mouseReleaseEvent ( QMouseEvent *mouseEvent )
{
    if( this->visibleRegion().contains( mouseEvent->pos() )){

        QPixmap pixmap =
                QPixmap::grabWidget(this,
                                    mouseEvent->x(),
                                    mouseEvent->y(),
                                    this->_taille_echantillon,
                                    this->_taille_echantillon);
        emit color_picked(
                this->couleurMoyenne( pixmap )
                );
    }
}
void ColorPickerScene::mouseMoveEvent ( QMouseEvent *mouseEvent )
{
    if( this->visibleRegion().contains( mouseEvent->pos() )){

        QPixmap pixmap =
                QPixmap::grabWidget(this,
                                    mouseEvent->x(),
                                    mouseEvent->y(),
                                    this->_taille_echantillon,
                                    this->_taille_echantillon);
        emit color_picked(
                this->couleurMoyenne( pixmap )
                );
    }
}

QColor* ColorPickerScene::couleurMoyenne( QPixmap pixmap )
{
    QColor d;
    QHash<int, QColor> colorTable;

    QHash<int, int> tableau_de_valeur_r;
    QHash<int, int> tableau_de_valeur_v;
    QHash<int, int> tableau_de_valeur_b;

    int freq_par_val_r = 0, freq_val_r = 0, c_r = 0;
    int freq_par_val_v = 0, freq_val_v = 0, c_v = 0;
    int freq_par_val_b = 0, freq_val_b = 0, c_b = 0;


    QImage Qim = pixmap.toImage();
    for( int i=0;i<Qim.width();i++){
        for( int e=0;e<Qim.width();e++){
            colorTable.insert(i+e,QColor(Qim.pixel(i , e )));
        }
    }

    for(int g=0;g<colorTable.count();g++){
        d = colorTable.value(g);

        if( tableau_de_valeur_r.contains(d.red()) == false )
            tableau_de_valeur_r.insert(d.red(), 1);
        else
            tableau_de_valeur_r[d.red()] = tableau_de_valeur_r[d.red()]+1;

        if( tableau_de_valeur_v.contains(d.green()) == false )
            tableau_de_valeur_v.insert(d.green(), 1);
        else
            tableau_de_valeur_v[d.green()]= tableau_de_valeur_v[d.green()]+1;


        if( tableau_de_valeur_b.contains(d.blue()) == false )
            tableau_de_valeur_b.insert(d.blue(), 1);
        else
            tableau_de_valeur_b[d.blue()] = tableau_de_valeur_b[d.blue()]+1;
    }

    QHashIterator<int, int> i(tableau_de_valeur_r);
    while (i.hasNext()) {
         i.next();
         freq_par_val_r += i.key() * i.value();
         freq_val_r += i.value();
     }

    QHashIterator<int, int> j(tableau_de_valeur_v);
    while (j.hasNext()) {
         j.next();
         freq_par_val_v += j.key() * j.value();
         freq_val_v += j.value();
     }

    QHashIterator<int, int> k(tableau_de_valeur_b);
    while (k.hasNext()) {
         k.next();
         freq_par_val_b += k.key() * k.value();
         freq_val_b += k.value();
     }


    if( freq_val_r > 0)
        c_r = freq_par_val_r/freq_val_r;
    if( freq_val_v > 0)
        c_v = freq_par_val_v/freq_val_v;
    if( freq_val_b > 0)
        c_b = freq_par_val_b/freq_val_b;

    return new QColor(c_r, c_v, c_b);
}
