<?php
/**
 * User Management
 *
 * User administration functions
 *
 * @package MultiUser
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: users.php,v 1.00 2006/12/05 18:15:00
 */

require_once './core/functions.php';
require_once './core/template.php';

localnet_or_die();
permission_or_die(PERM_ADMIN);

/**
 * Create user
 *
 * @param string $user Username
 * @param string $pass Password
 * @param string $perm permission as integer
 * @return boolean     true on success
 */
function create_user($user,$pass,$perm,$email)
{
	global $config;
	
    $pw = md5($pass);

    // acquire next free "real" user-id
    $SQL = "SELECT (MAX(id)+1) AS id FROM ".TBL_USERS." WHERE id != ".$config['guestid'].";";
    $nextid = runSQL($SQL);
    
    $SQL = "INSERT INTO ".TBL_USERS."
               SET id = ".$nextid[0]['id'].",
               	   name = '".addslashes($user)."',
                   passwd = '$pw',
                   permissions = $perm,
                   email = '".addslashes($email)."'";
    runSQL($SQL);
    return true;
}

// calculate permissions
$perm = 0;
if ($adminflag) $perm += PERM_ADMIN;
if ($writeflag) $perm += PERM_READ + PERM_WRITE;
elseif ($readflag) $perm += PERM_READ;
if ($mkcommentflag) $perm += PERM_MKCOMMENT;
if ($voteflag) $perm += PERM_VOTE;
if ($galleryflag) $perm += PERM_GALLERY;
if ($addgalleryflag) $perm += PERM_ADDGALLERY;






// new user?
if (!(empty($newuser) || empty($password)))
{
	create_user($newuser, $password, $perm, $email);
	$message = $lang['msg_usercreated'];
}

// update user?
elseif (!empty($id) &! empty($name))
{
    runSQL("UPDATE ".TBL_USERS."
               SET name = '".addslashes($name)."', permissions = $perm, email = '".addslashes($email)."'
			 WHERE id = $id");
	// new password?
	if (!empty($password))
	{
		$pw = md5($password);
        runSQL("UPDATE ".TBL_USERS." SET passwd = '$pw' WHERE id = '$id'");
		$message = $lang['msg_permpassupd'];
	} else {
		$message = $lang['msg_permupd'];
	}
}

// delete user?
elseif (!empty($del))
{
    validate_input($del);
    runSQL('DELETE FROM '.TBL_USERS.' WHERE id = '.$del);
    runSQL('DELETE FROM '.TBL_USERCONFIG.' WHERE user_id = '.$del);
	$message = $lang['msg_userdel'];
}

// current user permissions
$result = runSQL('SELECT id, name, permissions, email
                    FROM '.TBL_USERS.'
                ORDER BY name');
foreach ($result as $user)
{
	// is guest ?
	if ($user['id'] == $config['guestid']) $user['guest'] = 1;
	else $user['guest'] = 0;
	
	// don't show guest user if guest is disabled
	if ($config['denyguest'] && $user['guest']) 
    {
        continue;
    }
	 
	// collect and separate permission information
    $user['read']  = ($user['permissions'] & PERM_READ);
    $user['write'] = ($user['permissions'] & PERM_WRITE);
    $user['admin'] = ($user['permissions'] & PERM_ADMIN);
    $user['adult'] = ($user['permissions'] & PERM_ADULT);
    $user['mkcomment'] = ($user['permissions'] & PERM_MKCOMMENT);
	$user['vote'] = ($user['permissions'] & PERM_VOTE);
	$user['gallery'] = ($user['permissions'] & PERM_GALLERY);
	$user['addgallery'] = ($user['permissions'] & PERM_ADDGALLERY);
    $userlist[]    = $user;
}

// prepare templates
tpl_page('usermanager');
$smarty->assign('userlist', $userlist);
$smarty->assign('message', $message);
// display templates
tpl_display('users.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('users'.$id, httpCacheCaptureEnd());
}

?>
