<?php
/**
 * Clubs Detail View
 *
 * Shows all data for clubs
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_clubs.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_CLUBS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('clubs.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('clubs.id = '.$id);
        exit;
    }

if (!$season) {$season = $config['seasonfilterdefault'];}
$smarty->assign('season', $season);

$SELECT = 'SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname, '.TBL_CLUBS.'.longname, '.TBL_CLUBS.'.aka, '.TBL_CLUBS.'.country, '.TBL_CLUBS.'.city, '.TBL_CLUBS.'.imgurl, '.TBL_CLUBS.'.creation, '.TBL_CLUBS.'.website,  '.TBL_CLUBS.'.email, '.TBL_CLUBS.'.adresse, '.TBL_CLUBS.'.tel, '.TBL_CLUBS.'.fax, '.TBL_CLUBS.'.newspaper, '.TBL_CLUBS.'.owner_id, '.TBL_CLUBS.'.id_stadium as stadium_id, '.TBL_STADIUMS.'.longname as stadium, '.TBL_CLUBS.'.id_president as president_id, CONCAT('.TBL_PERSONS.'.firstname, " ", '.TBL_PERSONS.'.lastname) AS president, '.TBL_CLUBS.'.plot 
			FROM '.TBL_CLUBS.'
			LEFT JOIN '.TBL_STADIUMS.' ON '.TBL_STADIUMS.'.id = '.TBL_CLUBS.'.id_stadium
			LEFT JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_CLUBS.'.id_president
			WHERE '.TBL_CLUBS.'.id = \''.$id.'\';';
$res   = runSQL($SELECT);

// get the item
$club = $res[0];

$SELECT = 'SELECT CO.id, CO.shortname, SCO.shortname AS subshortname 
		   FROM '.TBL_CANDIDATES.' 
		   JOIN '.TBL_COMPETITIONS.' AS CO ON '.TBL_CANDIDATES.'.id_compet = CO.id
		   LEFT JOIN '.TBL_COMPETITIONS.' AS SCO ON CO.subcompet = SCO.id
		   WHERE '.TBL_CANDIDATES.'.id_season = '.$season.' AND '.TBL_CANDIDATES.'.id_club='.$id.';'; 
$competitions   = runSQL($SELECT);
$smarty->assign('competitions', $competitions);
 
$SELECT = 'SELECT DISTINCT '.TBL_CANDIDATES.'.id_season AS id, '.TBL_SEASONS.'.season 
		   FROM '.TBL_SEASONS.'
		   JOIN '.TBL_CANDIDATES.' ON '.TBL_CANDIDATES.'.id_season = '.TBL_SEASONS.'.id
		   WHERE '.TBL_CANDIDATES.'.id_club = '.$id.' ORDER BY '.TBL_SEASONS.'.season';
$seasonselect = runSQL($SELECT);
$smarty->assign('seasonselect', $seasonselect);  
	
	
	if ($config['clubstats'] && count($competitions)) {
		require_once './core/statistics.php';
		$club = array_merge ($club, StatsClubs($club, $competitions, $season));
		$smarty->assign('clubstats', $config['clubstats']);
	}	
	
    // is it editable/ copyable?
    //$club['editable'] = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $club['administrable'] = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$owners = split(',', $res[0]['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$club['editable'] = 1;
			}
		}
		if ($config['activecomments']) {
		$club['commentable'] = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $club['seegallery'] = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
        }
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $club['prev_id'] = ($key > 0) ? $ids[$key-1] : 0;
            $club['next_id'] = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}


// prepare templates
tpl_page('detailview', $club['name']);
if (!empty($id)) tpl_stats_clubs($club);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
if (!empty($id)) smarty_display('stats_clubs.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('stats_clubs'.$id, httpCacheCaptureEnd());
}

?>
