<?php
/**
 * Team Detail View
 *
 * Shows all data of a team
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_teams.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_CLUBS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('clubs.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('clubs.id = '.$id);
        exit;
    }


if (!$season) {$season = $config['seasonfilterdefault'];}
$smarty->assign('season', $season);

$SELECT = 'SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname, '.TBL_CLUBS.'.longname, ST.longname as stadium, ST.id as stadium_id, '.TBL_CLUBS.'.city, '.TBL_CLUBS.'.aka, '.TBL_CLUBS.'.country, '.TBL_CLUBS.'.creation, '.TBL_CLUBS.'.website, '.TBL_CLUBS.'.adresse, '.TBL_CLUBS.'.tel, '.TBL_CLUBS.'.fax, '.TBL_CLUBS.'.newspaper, '.TBL_CLUBS.'.imgurl 
		   FROM '.TBL_CLUBS.' 
		   LEFT JOIN '.TBL_STADIUMS.' AS ST ON '.TBL_CLUBS.'.id_stadium = ST.id
		   WHERE '.TBL_CLUBS.'.id = \''.$id.'\';'; 
$res   = runSQL($SELECT);

$SELECT = 'SELECT DISTINCT '.TBL_TEAMS.'.id_season AS id, '.TBL_SEASONS.'.season 
		   FROM '.TBL_SEASONS.'
		   JOIN '.TBL_TEAMS.' ON '.TBL_TEAMS.'.id_season = '.TBL_SEASONS.'.id
		   WHERE '.TBL_TEAMS.'.id_club = '.$id.' ORDER BY '.TBL_SEASONS.'.season';
$seasonselect = runSQL($SELECT);

$SELECT = 'SELECT '.TBL_SEASONS.'.id, '.TBL_SEASONS.'.season FROM '.TBL_SEASONS.' WHERE id='.$season;
$nameseason = runSQL($SELECT);
			 
	$teamplayers = getteambyclub($id, $season);	
	$teamcoach = getcoachbyclub($id, $season);	
	$numteamplayers = count($teamplayers);

	$smarty->assign('teamplayers', $teamplayers);
	$smarty->assign('teamcoach', $teamcoach[0]);
	$smarty->assign('seasonselect', $seasonselect);
	$smarty->assign('nameseason', $nameseason[0]);

    // existing id?
    if (!count($res)) redirect('clubs.php');
    // get the item
    $club = $res[0];
	
    // is it editable/ copyable?
    //$club['editable'] = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $club['administrable'] = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$owners = split(',', $res[0]['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$club['editable'] = 1;
			}
		}
		if ($config['activecomments']) {
		$club['commentable'] = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $club['seegallery'] = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
        }        
    }

    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $club['prev_id'] = ($key > 0) ? $ids[$key-1] : 0;
            $club['next_id'] = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

$smarty->assign('clubstats', $config['clubstats']);
// prepare templates
tpl_page('detailview', $club['name']);
tpl_show_teams($club);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('show_teams.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_teams'.$id, httpCacheCaptureEnd());
}

?>
