<?php
/**
 * Table Detail View
 *
 * Shows table for a competition
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_tables.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($competition)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_COMPETITIONS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$competition)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$competition = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($competition)) redirect('show_competitions.php');
}

// get data (id may be empty on a empty database)
if (!empty($competition))
{
	if (!$season) {$season = $config['seasonfilterdefault'];}


if (!$clmt) {$clmt = 'general';}


$SELECT = 'SELECT count(*) as numday FROM '.TBL_DAYS.' WHERE id_compet = '.$competition.' AND id_season = '.$season; 
$ret   = runSQL($SELECT);	
$numdays = $ret[0]['numday'];	
	
$SELECT = 'SELECT id, shortname, longname, active, aka, oneyear, type, country, creation, website, imgurl, owner_id, plot FROM '.TBL_COMPETITIONS.' WHERE '.TBL_COMPETITIONS.'.id = \''.$competition.'\';'; 
$res   = runSQL($SELECT);	
$competition = $res[0];

$SELECT = 'SELECT * from '.TBL_PARAMS.' WHERE id_season='.$season.' AND id_compet='.$competition['id'];
$params   = runSQL($SELECT);


$SELECT = 'SELECT '.TBL_SEASONS.'.season FROM '.TBL_SEASONS.' WHERE id = '.$season;				 
$nameseason = runSQL($SELECT);
		


		/*
		LEAGUE - CHAMPIONSHIP
		
		******table order instructions
		*[1]  = "points";
		*[2]  = "matchs gagns";
		*[3]  = "matchs nul";
		*[4]  = "diffrence de buts";
		*[5]  = "buts marqus";
		*[6]  = "points  domicile";
		*[7]  = "matchs gagns  domicile";
		*[8]  = "matchs nul  domicile";
		*[9]  = "diffrence de buts  domicile";
		*[10] = "buts marqus  domicile";
		*[11] = "points  l'exterieur";
		*[12] = "matchs gagns  l'exterieur";
		*[13] = "matchs nul  l'exterieur";
		*[14] = "diffrence de buts  l'exterieur";
		*[15] = "buts marqus  l'exterieur";
		*/
		$lastday = runSQL('SELECT '.TBL_DAYS.'.id, '.TBL_DAYS.'.day FROM '.TBL_DAYS.' WHERE '.TBL_DAYS.'.date_day <= NOW() AND id_compet='.$competition['id'].' AND id_season='.$season.' ORDER BY '.TBL_DAYS.'.date_day DESC LIMIT 1');
		if (!$day) {
			$day = $lastday[0]['day'];
			$maxday = $lastday[0]['day'];
		}
		else {
			$maxday = $lastday[0]['day'];
		}
		if (!$lastday) {
			$day = 1;
			$maxday = 1;
		}
		else if ($day > $lastday[0]['day']) {
			$day = $lastday[0]['day'];
			$maxday = $lastday[0]['day'];
		}
		$ORDER="";
		if ($params[0]['taborder']) {
			$table_order = array( 1 => 'pts DESC',2 => 'win DESC',3 => 'nul DESC',4 => '(sb - sa) DESC',5 => 'sb DESC',6 => 'dompts DESC',7 => 'domwin DESC',8 => 'domnul DESC',9 => '(domsb - domsa) DESC',10 => 'domsb DESC',11 => 'extpts DESC',12 => 'extwin DESC',13 => 'extnul DESC',14 => '(extsb - extsa) DESC',15 => 'extsb DESC' );
			$taborder = explode(',',$params[0]['taborder']);
			for ($x=0;$x<count($taborder);$x++) {
				if($ORDER) {$ORDER.=',';}
				$ORDER.=$table_order[$taborder[$x]];
			}
		}
		else {
			$ORDER = "pts DESC, (sb - sa) DESC, sb DESC";
		}
		if($ORDER) {$ORDER = 'ORDER BY '.$ORDER;}
		
		
		
		if ($day) {
		
			$maxday = $lastday[0]['day'];
		
			if ($clmt == 'attack') {
			$SELECT = 'SELECT '.TBL_CLUBS.'.id as id, '.TBL_CLUBS.'.shortname as name, '.TBL_CLMNT.'.pts as points, '.TBL_CLMNT.'.played as nummatch, '.TBL_CLMNT.'.win as victory, '.TBL_CLMNT.'.nul as nul, '.TBL_CLMNT.'.lost as lost, '.TBL_CLMNT.'.sb as bp, '.TBL_CLMNT.'.sa as bc, ('.TBL_CLMNT.'.sb - '.TBL_CLMNT.'.sa) as diff
			FROM '.TBL_CLMNT.'
			JOIN '.TBL_CLUBS.' ON '.TBL_CLUBS.'.id = '.TBL_CLMNT.'.id_team
			WHERE '.TBL_CLMNT.'.id_season='.$season.' AND '.TBL_CLMNT.'.id_compet = '.$competition['id'].' AND '.TBL_CLMNT.'.id_day='.$day.' ORDER BY bp DESC, points DESC, diff DESC';
			}
			else if ($clmt == 'defense') {
			$SELECT = 'SELECT '.TBL_CLUBS.'.id as id, '.TBL_CLUBS.'.shortname as name, '.TBL_CLMNT.'.pts as points, '.TBL_CLMNT.'.played as nummatch, '.TBL_CLMNT.'.win as victory, '.TBL_CLMNT.'.nul as nul, '.TBL_CLMNT.'.lost as lost, '.TBL_CLMNT.'.sb as bp, '.TBL_CLMNT.'.sa as bc, ('.TBL_CLMNT.'.sb - '.TBL_CLMNT.'.sa) as diff
			FROM '.TBL_CLMNT.'
			JOIN '.TBL_CLUBS.' ON '.TBL_CLUBS.'.id = '.TBL_CLMNT.'.id_team
			WHERE '.TBL_CLMNT.'.id_season='.$season.' AND '.TBL_CLMNT.'.id_compet = '.$competition['id'].' AND '.TBL_CLMNT.'.id_day='.$day.' ORDER BY bc ASC, points DESC, diff DESC';
			}
			else if ($clmt == 'domicile') {
			$SELECT = 'SELECT '.TBL_CLUBS.'.id as id, '.TBL_CLUBS.'.shortname as name, '.TBL_CLMNT.'.dompts as points, '.TBL_CLMNT.'.domplayed as nummatch, '.TBL_CLMNT.'.domwin as victory, '.TBL_CLMNT.'.domnul as nul, '.TBL_CLMNT.'.domlost as lost, '.TBL_CLMNT.'.domsb as bp, '.TBL_CLMNT.'.domsa as bc, ('.TBL_CLMNT.'.domsb - '.TBL_CLMNT.'.domsa) as diff
			FROM '.TBL_CLMNT.'
			JOIN '.TBL_CLUBS.' ON '.TBL_CLUBS.'.id = '.TBL_CLMNT.'.id_team
			WHERE '.TBL_CLMNT.'.id_season='.$season.' AND '.TBL_CLMNT.'.id_compet = '.$competition['id'].' AND '.TBL_CLMNT.'.id_day='.$day.' ORDER BY points DESC, diff DESC, bp DESC';
			}
			else if ($clmt == 'exterieur') {
			$SELECT = 'SELECT '.TBL_CLUBS.'.id as id, '.TBL_CLUBS.'.shortname as name, '.TBL_CLMNT.'.extpts as points, '.TBL_CLMNT.'.extplayed as nummatch, '.TBL_CLMNT.'.extwin as victory, '.TBL_CLMNT.'.extnul as nul, '.TBL_CLMNT.'.extlost as lost, '.TBL_CLMNT.'.extsb as bp, '.TBL_CLMNT.'.extsa as bc, ('.TBL_CLMNT.'.extsb - '.TBL_CLMNT.'.extsa) as diff
			FROM '.TBL_CLMNT.'
			JOIN '.TBL_CLUBS.' ON '.TBL_CLUBS.'.id = '.TBL_CLMNT.'.id_team
			WHERE '.TBL_CLMNT.'.id_season='.$season.' AND '.TBL_CLMNT.'.id_compet = '.$competition['id'].' AND '.TBL_CLMNT.'.id_day='.$day.' ORDER BY points DESC, diff DESC, bp DESC';
			}
			else {
			$SELECT = 'SELECT '.TBL_CLUBS.'.id as id, '.TBL_CLUBS.'.shortname as name, '.TBL_CLMNT.'.pts as points, '.TBL_CLMNT.'.played as nummatch, '.TBL_CLMNT.'.win as victory, '.TBL_CLMNT.'.nul as nul, '.TBL_CLMNT.'.lost as lost, '.TBL_CLMNT.'.sb as bp, '.TBL_CLMNT.'.sa as bc, ('.TBL_CLMNT.'.sb - '.TBL_CLMNT.'.sa) as diff
			FROM '.TBL_CLMNT.'
			JOIN '.TBL_CLUBS.' ON '.TBL_CLUBS.'.id = '.TBL_CLMNT.'.id_team
			WHERE '.TBL_CLMNT.'.id_season='.$season.' AND '.TBL_CLMNT.'.id_compet = '.$competition['id'].' AND '.TBL_CLMNT.'.id_day='.$day.' '.$ORDER;
			}  
			$clubstats   = runSQL($SELECT);
		}//if $day

	
//VIEW PAGE CONFIGURATION
	
    // is it editable/ copyable?
    //$editable = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $administrable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$owners = split(',', $competition['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$editable = 1;
			}
		}
		if ($config['activecomments']) {
		$commentable = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $seegallery = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
		}        
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

if (!$season) {$season = $config['seasonfilterdefault'];}
if ($config['competitionstats'] && $competition['active']) {
$smarty->assign('statsactive', 1);
}
$smarty->assign('season', $season);
$smarty->assign('editable', $editable);
$smarty->assign('administrable', $administrable);
$smarty->assign('commentable', $commentable);
$smarty->assign('prev_id', $prev_id);
$smarty->assign('next_id', $next_id);
$smarty->assign('seegallery', $seegallery);
$smarty->assign('actiontitle', $competition['longname']);
$smarty->assign('clubstats', $clubstats);
$smarty->assign('numdays', $numdays);
$smarty->assign('day', $day);
$smarty->assign('maxday', $maxday);
$smarty->assign('clmt', $clmt);
$smarty->assign('params', $params[0]);
$smarty->assign('nameseason', $nameseason[0]);
$smarty->assign('competition', $competition);
$smarty->assign('countmatchs', $countmatchs);

// prepare templates
tpl_page('detailview', $competition['name']);
if (!empty($competition)) tpl_show_tables($competition);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();


if (!empty($competition)) smarty_display('actions_competitions.tpl', $competition);
if (!empty($competition)) smarty_display('show_tables.tpl', $competition);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_tables'.$competition['id'], httpCacheCaptureEnd());
}

?>
