<?php
/**
 * Stats Detail View
 *
 * Shows all stats for a club
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_stats.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';
require_once './core/graphs.php';

if (empty($id)) redirect('show_matchs.php');

// get data (id may be empty on a empty database)
if (!empty($id))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('match.id = '.$id);
        exit;
    }
	


$SELECT = 'SELECT '.TBL_MATCHS.'.id, '.TBL_DAYS.'.id_compet, '.TBL_DAYS.'.id_season, '.TBL_DAYS.'.day, '.TBL_MATCHS.'.id_candidate_dom, T1.shortname AS domclub, T1.imgurl AS domimg, '.TBL_MATCHS.'.id_candidate_ext,  T2.shortname AS extclub, T2.imgurl AS extimg, '.TBL_MATCHS.'.id_day, '.TBL_MATCHS.'.date_day, '.TBL_MATCHS.'.buts_dom, '.TBL_MATCHS.'.buts_ext, '.TBL_MATCHS.'.id_referee, CONCAT('.TBL_PERSONS.'.firstname, " ", '.TBL_PERSONS.'.lastname) AS referee, '.TBL_MATCHS.'.id_stadium, '.TBL_STADIUMS.'.longname AS stadium, '.TBL_MATCHS.'.id_weather, '.TBL_MATCHS.'.temperature, '.TBL_MATCHS.'.plot
			FROM '.TBL_MATCHS.' 
			JOIN '.TBL_CLUBS.' AS T1 ON T1.id = '.TBL_MATCHS.'.id_candidate_dom 
			JOIN '.TBL_CLUBS.' AS T2 ON T2.id = '.TBL_MATCHS.'.id_candidate_ext
			LEFT JOIN '.TBL_STADIUMS.' ON '.TBL_STADIUMS.'.id = '.TBL_MATCHS.'.id_stadium
			LEFT JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_MATCHS.'.id_referee
			JOIN '.TBL_DAYS.'  ON '.TBL_DAYS.'.id = '.TBL_MATCHS.'.id_day
			WHERE '.TBL_MATCHS.'.id = '.$id.';'; 
$res   = runSQL($SELECT);

$competition['id'] = $res[0]['id_compet'];

$SELECT = 'SELECT id, shortname, longname, aka, type, range, country, creation, website, imgurl, plot FROM '.TBL_COMPETITIONS.' WHERE id = '.$res[0]['id_compet'];				 
$competdata = runSQL($SELECT);




	$SELECT = 'SELECT count(id) AS count FROM '.TBL_DAYS.' WHERE id_season = '.$res[0]['id_season'].' AND id_compet='.$res[0]['id_compet'].';';
	$numdays = runSQL($SELECT);
	
	$SELECT = 'SELECT count(id) AS count FROM '.TBL_CANDIDATES.' WHERE id_season = '.$res[0]['id_season'].' AND id_compet='.$res[0]['id_compet'].';';
	$numclubs = runSQL($SELECT);
	
	$SELECT = 'SELECT '.TBL_DAYS.'.day, '.TBL_MATCHS.'.buts_dom, '.TBL_MATCHS.'.buts_ext, T2.shortname
	FROM '.TBL_MATCHS.'
	JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id
	JOIN '.TBL_CLUBS.' AS T2 ON T2.id = '.TBL_MATCHS.'.id_candidate_ext
	WHERE '.TBL_MATCHS.'.id_candidate_dom = '.$res[0]['id_candidate_dom'].'
	AND '.TBL_DAYS.'.id_compet = '.$res[0]['id_compet'].'
	AND '.TBL_DAYS.'.id_season = '.$res[0]['id_season'].'
	AND '.TBL_MATCHS.'.date_day < \''.$res[0]['date_day'].'\'
	ORDER BY '.TBL_MATCHS.'.date_day DESC
	LIMIT 5 ;';
	$dommatchs   = runSQL($SELECT);
	
	for ($x=0; $x<count($dommatchs); $x++) {
		if ($dommatchs[$x]['buts_dom'] > $dommatchs[$x]['buts_ext']) {$domseries[$x] = $lang['victory_abr'];}
		else if ($dommatchs[$x]['buts_dom'] < $dommatchs[$x]['buts_ext']) {$domseries[$x] = $lang['defeat_abr'];}
		else {$domseries[$x] = $lang['nul_abr'];}
	}
	
	$SELECT = 'SELECT '.TBL_DAYS.'.day, '.TBL_MATCHS.'.buts_dom, '.TBL_MATCHS.'.buts_ext, T1.shortname
	FROM '.TBL_MATCHS.'
	JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id
	JOIN '.TBL_CLUBS.' AS T1 ON T1.id = '.TBL_MATCHS.'.id_candidate_dom
	WHERE '.TBL_MATCHS.'.id_candidate_ext = '.$res[0]['id_candidate_ext'].'
	AND '.TBL_DAYS.'.id_compet = '.$res[0]['id_compet'].'
	AND '.TBL_DAYS.'.id_season = '.$res[0]['id_season'].'
	AND '.TBL_MATCHS.'.date_day < \''.$res[0]['date_day'].'\'
	ORDER BY '.TBL_MATCHS.'.date_day DESC
	LIMIT 5 ;';
	$extmatchs   = runSQL($SELECT);
	
	for ($x=0; $x<count($extmatchs); $x++) {
		if ($extmatchs[$x]['buts_dom'] > $extmatchs[$x]['buts_ext']) {$extseries[$x] = $lang['defeat_abr'];}
		else if ($extmatchs[$x]['buts_dom'] < $extmatchs[$x]['buts_ext']) {$extseries[$x] = $lang['victory_abr'];}
		else {$extseries[$x] = $lang['nul_abr'];}
	}
	
	
	$SELECT = 'SELECT C1.id_team, count( C2.id_team ) AS rang, C1.pts, C1.id_day, C1.domplayed, C1.domwin, C1.domnul, C1.domlost, C1.domsb, C1.domsa, (C1.sb-C1.sa) AS diff
	FROM '.TBL_CLMNT.' AS C1
	JOIN '.TBL_DAYS.' ON '.TBL_DAYS.'.id = C1.id_day
	JOIN '.TBL_CLMNT.' AS C2 ON  C1.pts < C2.pts
	OR (C1.pts = C2.pts AND C1.sb-C1.sa < C2.sb-C2.sa)
	OR (C1.pts = C2.pts AND C1.sb-C1.sa = C2.sb-C2.sa AND C1.sb <= C2.sb)
	WHERE '.TBL_DAYS.'.day < '.$res[0]['day'].' 
	AND C1.id_team = '.$res[0]['id_candidate_dom'].'
	AND C1.id_season = '.$res[0]['id_season'].'
	AND C2.id_season = '.$res[0]['id_season'].'
	AND C1.id_compet = '.$res[0]['id_compet'].'
	AND C2.id_compet = '.$res[0]['id_compet'].'
	AND C1.id_day = C2.id_day
	AND C1.id_day < '.$res[0]['id_day'].'
	GROUP BY C1.id_day';
	
	$domevolution = runSQL($SELECT);
	
	
	
	$SELECT = 'SELECT C1.id_team, count( C2.id_team ) AS rang, C1.pts, C1.id_day, C1.extplayed, C1.extwin, C1.extnul, C1.extlost, C1.extsb, C1.extsa, (C1.sb-C1.sa) AS diff
	FROM '.TBL_CLMNT.' AS C1
	JOIN '.TBL_DAYS.' ON '.TBL_DAYS.'.id = C1.id_day
	JOIN '.TBL_CLMNT.' AS C2 ON  C1.pts < C2.pts
	OR (C1.pts = C2.pts AND C1.sb-C1.sa < C2.sb-C2.sa)
	OR (C1.pts = C2.pts AND C1.sb-C1.sa = C2.sb-C2.sa AND C1.sb <= C2.sb)
	WHERE '.TBL_DAYS.'.day < '.$res[0]['day'].' 
	AND C1.id_team = '.$res[0]['id_candidate_ext'].'
	AND C1.id_season = '.$res[0]['id_season'].'
	AND C2.id_season = '.$res[0]['id_season'].'
	AND C1.id_compet = '.$res[0]['id_compet'].'
	AND C2.id_compet = '.$res[0]['id_compet'].'
	AND C1.id_day = C2.id_day
	AND C1.id_day < '.$res[0]['id_day'].'
	GROUP BY C1.id_day';
	$extevolution = runSQL($SELECT);

	
// Start if League

if ($competdata[0]['type'] == 2) {
		
	$mygraph = makegraph($domevolution, $extevolution, $numdays[0]['count'], $numclubs[0]['count'], $id);
}
// End if League

$SELECT = 'SELECT '.TBL_GOALS.'.id_person, '.TBL_PERSONS.'.lastname, '.TBL_PERSONS.'.firstname, '.TBL_PERSONS.'.imgurl, count('.TBL_GOALS.'.id_person) AS goals
FROM '.TBL_GOALS.'
JOIN '.TBL_MATCHS.' ON '.TBL_MATCHS.'.id = '.TBL_GOALS.'.id_match
JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_GOALS.'.id_person
JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id
WHERE '.TBL_MATCHS.'.id_candidate_dom = '.$res[0]['id_candidate_dom'].'
AND '.TBL_DAYS.'.id_compet = '.$res[0]['id_compet'].'
AND '.TBL_DAYS.'.id_season = '.$res[0]['id_season'].'
GROUP BY id_person
ORDER BY goals DESC LIMIT 1';
$domgoleador = runSQL($SELECT);

$SELECT = 'SELECT '.TBL_GOALS.'.id_person, '.TBL_PERSONS.'.lastname, '.TBL_PERSONS.'.firstname, '.TBL_PERSONS.'.imgurl, count('.TBL_GOALS.'.id_person) AS goals
FROM '.TBL_GOALS.'
JOIN '.TBL_MATCHS.' ON '.TBL_MATCHS.'.id = '.TBL_GOALS.'.id_match
JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_GOALS.'.id_person
JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id
WHERE '.TBL_MATCHS.'.id_candidate_ext = '.$res[0]['id_candidate_ext'].'
AND '.TBL_DAYS.'.id_compet = '.$res[0]['id_compet'].'
AND '.TBL_DAYS.'.id_season = '.$res[0]['id_season'].'
GROUP BY id_person
ORDER BY goals DESC LIMIT 1';
$extgoleador = runSQL($SELECT);


	
	
	$SELECT = 'SELECT '.TBL_SEASONS.'.season
                 FROM '.TBL_SEASONS.'
                 WHERE id = '.$res[0]['id_season'];				 
	$nameseason = runSQL($SELECT);
	
    // existing id?
    if (!count($res)) redirect('competitions.php');
    
    // get the item
    $matchs = $res[0];
	
	
    // is it editable/ copyable?
    $editable = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $editable = check_permission(PERM_WRITE, $_COOKIE['PCSuserid']);
		if ($config['activecomments']) {
		$commentable = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $seegallery = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
		}
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($competition, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

if (!$season) {$season = $config['seasonfilterdefault'];}

$smarty->assign('competition', $competition);
$smarty->assign('competdata', $competdata[0]);
$smarty->assign('day', $day);
$smarty->assign('showstats', $showstats);
$smarty->assign('season', $season);
$smarty->assign('haveseason', $season);
$smarty->assign('editable', $editable);
$smarty->assign('commentable', $commentable);
$smarty->assign('prev_id', $prev_id);
$smarty->assign('next_id', $next_id);
$smarty->assign('seegallery', $seegallery);
$smarty->assign('dommatchs', $dommatchs);
$smarty->assign('extmatchs', $extmatchs);
$smarty->assign('domseries', $domseries);
$smarty->assign('domstats', $domevolution[count($domevolution)-1]);
$smarty->assign('domgoleador', $domgoleador[0]);
$smarty->assign('extseries', $extseries);
$smarty->assign('extstats', $extevolution[count($extevolution)-1]);
$smarty->assign('extgoleador', $extgoleador[0]);
$smarty->assign('mygraph', $mygraph);
$smarty->assign('actiontitle', $competdata[0]['longname'] .' - ' .$nameseason[0]['season'] . '/' . ($nameseason[0]['season']+1));

// prepare templates
tpl_page('detailview', $matchs['name']);
tpl_show_stats($matchs,$competition);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('actions_competitions.tpl', $id);
smarty_display('show_stats.tpl', $competition);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_stats'.$id, httpCacheCaptureEnd());
}

?>
