<?php
/**
 * Stadium Detail View
 *
 * Shows all data of a stadium
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_stadiums.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_STADIUMS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('stadiums.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('stadiums.id = '.$id);
        exit;
    }

$SELECT = 'SELECT id, longname, aka, country, creation, renovation,  places, adresse, imgurl, plot FROM '.TBL_STADIUMS.' WHERE '.TBL_STADIUMS.'.id = \''.$id.'\';'; 
$res   = runSQL($SELECT);

    // existing id?
    if (!count($res)) redirect('stadiums.php');
    // get the item
    $stadium = $res[0];
	//get additionals caracs 
	$stadium['carac_ads'] = get_carac('3',$id);
    // is it editable/ copyable?
    $stadium['editable'] = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $stadium['editable'] = check_permission(PERM_WRITE, $_COOKIE['PCSuserid']);
		
		if ($config['activecomments']) {
		$stadium['commentable'] = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $stadium['seegallery'] = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
		}        
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $stadium['prev_id'] = ($key > 0) ? $ids[$key-1] : 0;
            $stadium['next_id'] = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}


// prepare templates
tpl_page('detailview', $stadium['name']);
if (!empty($id)) tpl_show_stadiums($stadium);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
if (!empty($id)) smarty_display('show_stadiums.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_stadiums'.$id, httpCacheCaptureEnd());
}

?>
