<?php
/**
 * Persons Detail View
 *
 * Shows all data for persons
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_persons.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_PERSONS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('persons.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

$SELECT = 'SELECT '.TBL_PERSONS.'.id, '.TBL_PERSONS.'.lastname, '.TBL_PERSONS.'.firstname, '.TBL_PERSONS.'.aka, '.TBL_CLUBS.'.id AS id_club, '.TBL_CLUBS.'.shortname AS clubname, '.TBL_PERSONS.'.country, '.TBL_PERSONS.'.birthday, '.TBL_PERSONS.'.birthcity, '.TBL_PERSONS.'.deathday, 
'.TBL_PERSONS.'.position, '.TBL_PERSONS.'.height, '.TBL_PERSONS.'.weight, '.TBL_PERSONS.'.type, '.TBL_PERSONS.'.international, '.TBL_PERSONS.'.imgurl, '.TBL_PERSONS.'.contribution, 
'.TBL_PERSONS.'.stop_mail, '.TBL_PERSONS.'.email, '.TBL_PERSONS.'.license, '.TBL_PERSONS.'.website, '.TBL_PERSONS.'.address, '.TBL_PERSONS.'.tel1, '.TBL_PERSONS.'.tel2, '.TBL_PERSONS.'.plot 
FROM '.TBL_PERSONS.'
LEFT JOIN '.TBL_TEAMS.' ON '.TBL_TEAMS.'.id_person = '.TBL_PERSONS.'.id AND '.TBL_TEAMS.'.id_season ='.$config['seasonfilterdefault'].'
LEFT JOIN '.TBL_CLUBS.' ON '.TBL_TEAMS.'.id_club = '.TBL_CLUBS.'.id
WHERE '.TBL_PERSONS.'.id = \''.$id.'\';'; 
$res   = runSQL($SELECT);

// existing id?
if (!count($res)) redirect('persons.php');
// get the item
$person = $res[0];
//get additionals caracs 
$person['carac_ads'] = get_carac('4',$id);
 
if ($config['playerstats']) {
require_once './core/statistics.php';

	if ($person['id_club'] && $person['type'] == 1) {
		$person = array_merge ($person, StatsPlayers($person));
	}
	else if ($person['type'] == 3) {
		$person = array_merge ($person, StatsReferees($person));
	}

}

// is it editable/ copyable?
$person['editable'] = localnet();

// multi-user permissions
if ($config['multiuser'])
{
	$person['editable'] = check_permission(PERM_WRITE, $_COOKIE['PCSuserid']);
	if ($config['activecomments']) {
	$person['commentable'] = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
	}
	if ($config['activegallery']) {
    $person['seegallery'] = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
	}
}



    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $person['prev_id'] = ($key > 0) ? $ids[$key-1] : 0;
            $person['next_id'] = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

 
// prepare templates
tpl_page('detailview', $person['name']);
if (!empty($id)) tpl_show_persons($person);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
if (!empty($id)) smarty_display('show_persons.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_persons'.$id, httpCacheCaptureEnd());
}

?>
