<?php
/**
 * News Detail View
 *
 * Shows all data for a news
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_news.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_NEWS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('index.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('news.id = '.$id);
        exit;
    }

			
$SELECT = 'SELECT '.TBL_NEWS.'.id, '.TBL_NEWS.'.title, '.TBL_NEWS.'.category, '.TBL_NEWS.'.language, '.TBL_NEWS.'.imgurl, '.TBL_NEWS.'.summary, '.TBL_NEWS.'.plot, '.TBL_NEWS.'.link, '.TBL_NEWS.'.newsfrom, '.TBL_NEWS.'.pubdate, '.TBL_USERS.'.name AS owner 
			FROM '.TBL_NEWS.'
			LEFT JOIN '.TBL_USERS.' ON '.TBL_NEWS.'.owner_id = '.TBL_USERS.'.id
			WHERE '.TBL_NEWS.'.id = \''.$id.'\';';
$res   = runSQL($SELECT);

    // get the item
    $news = $res[0];
	
	
    // is it editable/ copyable?
    $news['editable'] = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $news['editable'] = check_permission(PERM_WRITE, $_COOKIE['PCSuserid']);
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $news['prev_id'] = ($key > 0) ? $ids[$key-1] : 0;
            $news['next_id'] = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}


// prepare templates
tpl_page('detailview', $news['name']);
if (!empty($id)) tpl_show_news($news);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
if (!empty($id)) smarty_display('show_news.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_news'.$id, httpCacheCaptureEnd());
}

?>
