<?php
/**
 * Members Detail View
 *
 * Show all data for members
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_members.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_USERS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('members.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('members.id = '.$id);
        exit;
    }

$SELECT = 'SELECT '.TBL_USERS.'.id, '.TBL_USERS.'.name 
			FROM '.TBL_USERS.'
			WHERE '.TBL_USERS.'.id = \''.$id.'\';';
$memberid   = runSQL($SELECT);


$SELECT = 'SELECT * 
			FROM '.TBL_USERCONFIG.'
			WHERE '.TBL_USERCONFIG.'.user_id = \''.$memberid[0]['id'].'\';';
$memberconfig   = runSQL($SELECT);

$SELECT = 'SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.longname 
			FROM '.TBL_CLUBS.'
			WHERE '.TBL_CLUBS.'.owner_id RLIKE \','.$id.',\';';
$club_ownerid   = runSQL($SELECT);
$smarty->assign('club_ownerid ', $club_ownerid);

$SELECT = 'SELECT '.TBL_COMPETITIONS.'.id, '.TBL_COMPETITIONS.'.longname 
			FROM '.TBL_COMPETITIONS.'
			WHERE '.TBL_COMPETITIONS.'.owner_id RLIKE \','.$id.',\';';
$compet_ownerid   = runSQL($SELECT);
$smarty->assign('compet_ownerid', $compet_ownerid);

for ($x=0; $x<count($memberconfig); $x++) {
$member[$memberconfig[$x]['opt']] = $memberconfig[$x]['value'];
}

    // is it editable/ copyable?
    $memberid[0]['editable'] = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $memberid[0]['editable'] = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		if ($memberid[0]['editable']) {
			if($activedit) {$member[0]['editactive'] = 1;}
		}
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $memberid[0]['prev_id'] = ($key > 0) ? $ids[$key-1] : 0;
            $memberid[0]['next_id'] = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

$smarty->assign('memberid', $memberid[0]);


// prepare templates
tpl_page('detailview', $member['name']);
if (!empty($id)) tpl_show_members($member);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
if (!empty($id)) smarty_display('show_members.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_members'.$id, httpCacheCaptureEnd());
}

?>
