<?php
/**
 * Matchs Detail View
 *
 * Shows all data for matchs
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_matchs.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';

if (!$season) {$season = $config['seasonfilterdefault'];}

// get data (id may be empty on a empty database)
if (!empty($competition) && !empty($season))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('competitions.id = '.$competition);
        exit;
    }
	
	$SELECT = 'SELECT '.TBL_DAYS.'.id FROM '.TBL_DAYS.' WHERE id_compet = '.$competition.' AND id_season='.$season;				 
	$days = runSQL($SELECT);
	$numdays=count($days);

	
	$mylastday = runSQL('SELECT '.TBL_DAYS.'.day FROM '.TBL_DAYS.' WHERE id_compet = '.$competition.' AND id_season='.$season . ' AND '.TBL_DAYS.'.date_day <= NOW() ORDER BY '.TBL_DAYS.'.date_day DESC LIMIT 1');
	$lastday = $mylastday[0]['day'];
	
	if (!$day) {
		if ($lastday) {
		$day = $lastday;
		}
		else {
		$day = 1;
		}
	}
	if ($day <= $lastday) {
	$showmatch = $lastday;
	}
	else if ($day <= $lastday+1) {	
	$showstats = $lastday;
	}


if ($day) {
$SELECT = 'SELECT '.TBL_MATCHS.'.id, '.TBL_MATCHS.'.id_candidate_dom, '.TBL_MATCHS.'.id_candidate_ext, '.TBL_MATCHS.'.id_day, '.TBL_MATCHS.'.date_day, TIMEDIFF('.TBL_MATCHS.'.date_day, NOW()) AS timediff, '.TBL_MATCHS.'.buts_dom, '.TBL_MATCHS.'.buts_ext, '.TBL_MATCHS.'.id_referee, '.TBL_MATCHS.'.id_stadium, '.TBL_MATCHS.'.spectators, '.TBL_MATCHS.'.id_weather, '.TBL_MATCHS.'.temperature, '.TBL_MATCHS.'.validation, '.TBL_MATCHS.'.plot
			FROM '.TBL_MATCHS.' 
			LEFT JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id 
			WHERE '.TBL_DAYS.'.id_compet = '.$competition.' AND '.TBL_DAYS.'.id_season = '.$season.' AND '.TBL_DAYS.'.day = '.$day.' ORDER BY '.TBL_MATCHS.'.date_day;'; 
$res   = runSQL($SELECT);
}

	//$SELECT = 'SELECT id, longname, type, range FROM '.TBL_COMPETITIONS.' WHERE id = '.$competition;
				 
	$SELECT = 'SELECT '.TBL_COMPETITIONS.'.id, '.TBL_COMPETITIONS.'.shortname, SCO.shortname AS subshortname, '.TBL_COMPETITIONS.'.longname, '.TBL_COMPETITIONS.'.imgurl, '.TBL_COMPETITIONS.'.type, '.TBL_COMPETITIONS.'.creation, '.TBL_COMPETITIONS.'.website, '.TBL_COMPETITIONS.'.range, '.TBL_COMPETITIONS.'.owner_id, '.TBL_COMPETITIONS.'.oneyear, '.TBL_PARAMS.'.ar 
				FROM '.TBL_COMPETITIONS.' 
				LEFT JOIN '.TBL_PARAMS.' ON '.TBL_COMPETITIONS.'.id = '.TBL_PARAMS.'.id_compet
				LEFT JOIN '.TBL_COMPETITIONS.' AS SCO ON '.TBL_COMPETITIONS.'.subcompet = SCO.id		   
		   		WHERE '.TBL_COMPETITIONS.'.id = '.$competition;
	$competdata = runSQL($SELECT);
	
	$SELECT = 'SELECT '.TBL_SEASONS.'.season
                 FROM '.TBL_SEASONS.'
                 WHERE id = '.$season;				 
	$nameseason = runSQL($SELECT);
	
    // existing id?
    if (!count($res)) redirect('competitions.php');
    
    // get the item
    $matchs = $res;
	$nummatchs = count($res);
	
	
    // is it editable/ copyable?
    //$editable = localnet();
   
    // multi-user permissions
    if ($config['multiuser'])
    {
        $administrable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$owners = split(',', $competdata[0]['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$editable = 1;
			}
		}
		if ($config['activecomments']) {
		$commentable = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $seegallery = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
		}
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($competition, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

if ($competdata[0]['subshortname']) {$actiontitle = $competdata[0]['subshortname'].' - '.$competdata[0]['longname'] .' - ' .$nameseason[0]['season'];}
else {$actiontitle = $competdata[0]['longname'] .' - ' .$nameseason[0]['season'];}

if (!$competdata[0]['oneyear']) {$actiontitle .= '/' . ($nameseason[0]['season']+1);}

if ($competdata[0]['type'] == 1) {
$smarty->assign('competday', $competday);
}
$smarty->assign('competition', $competdata[0]);
if ($config['competitionstats'] && $competition['active']) {
$smarty->assign('statsactive', 1);
}

$smarty->assign('day', $day);
$smarty->assign('showmatch', $showmatch);
$smarty->assign('showstats', $showstats);
$smarty->assign('season', $season);
$smarty->assign('haveseason', $season);
$smarty->assign('administrable', $administrable);
$smarty->assign('editable', $editable);
$smarty->assign('commentable', $commentable);
$smarty->assign('prev_id', $prev_id);
$smarty->assign('next_id', $next_id);
$smarty->assign('seegallery', $seegallery);
$smarty->assign('nummatchs', $nummatchs);
$smarty->assign('numdays', $numdays);
$smarty->assign('actiontitle', $actiontitle);

// prepare templates
tpl_page('detailview', $matchs['name']);
tpl_show_matchs($matchs,$competdata[0]);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('actions_competitions.tpl', $id);
smarty_display('show_matchs.tpl', $competition);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_matchs'.$competition.$season, httpCacheCaptureEnd());
}

?>
