<?php
/**
 * Match Detail View
 *
 * Shows all data for a match
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_match.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// get data (id may be empty on a empty database)
if (!empty($id))
{
$SELECT = 'SELECT '.TBL_MATCHS.'.id, '.TBL_MATCHS.'.id_candidate_dom, C1.shortname AS domclub, C1.imgurl AS domimg, '.TBL_MATCHS.'.id_candidate_ext, C2.shortname AS extclub, C2.imgurl AS extimg, 
				  '.TBL_MATCHS.'.id_day, '.TBL_MATCHS.'.date_day, '.TBL_DAYS.'.day, '.TBL_MATCHS.'.buts_dom, '.TBL_MATCHS.'.buts_ext, '.TBL_MATCHS.'.id_referee, '.TBL_PERSONS.'.lastname AS refereelast,
				  '.TBL_PERSONS.'.id AS refereeid, '.TBL_PERSONS.'.firstname AS refereefirst, '.TBL_MATCHS.'.id_stadium, '.TBL_STADIUMS.'.id AS idstadium, '.TBL_STADIUMS.'.longname AS stadium,
				  '.TBL_MATCHS.'.spectators, '.TBL_MATCHS.'.id_weather, '.TBL_MATCHS.'.temperature, '.TBL_MATCHS.'.plot, '.TBL_DAYS.'.id_compet, '.TBL_DAYS.'.id_season
			FROM '.TBL_MATCHS.' 
			JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id 
			LEFT JOIN '.TBL_STADIUMS.' ON '.TBL_MATCHS.'.id_stadium = '.TBL_STADIUMS.'.id 
			LEFT JOIN '.TBL_PERSONS.' ON '.TBL_MATCHS.'.id_referee = '.TBL_PERSONS.'.id 
			JOIN '.TBL_CLUBS.' AS C1 ON '.TBL_MATCHS.'.id_candidate_dom = C1.id 
			JOIN '.TBL_CLUBS.' AS C2 ON '.TBL_MATCHS.'.id_candidate_ext = C2.id 
			WHERE '.TBL_MATCHS.'.id = '.$id.' AND 1=1;'; 
$res   = runSQL($SELECT);



// XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('competitions.id = '.$res[0]['id_compet']);
        exit;
    }


	$SELECT = 'SELECT id_person, '.TBL_PERSONS.'.firstname AS first, '.TBL_PERSONS.'.lastname AS last, id_club, goal_min, goal_csc, goal_pen 
			   FROM '.TBL_GOALS.'
			   JOIN '.TBL_PERSONS.' ON '.TBL_GOALS.'.id_person = '.TBL_PERSONS.'.id
			   WHERE id_match = '.$id.' ORDER BY goal_min';				 
	$goleadors = runSQL($SELECT);

	$SELECT = 'SELECT id_person, '.TBL_PERSONS.'.firstname AS first, '.TBL_PERSONS.'.lastname AS last, id_club, card_min, card_yellow, card_red 
			   FROM '.TBL_CARDS.'
			   JOIN '.TBL_PERSONS.' ON '.TBL_CARDS.'.id_person = '.TBL_PERSONS.'.id
			   WHERE id_match = '.$id.' ORDER BY card_min';				 
	$cards = runSQL($SELECT);

	$SELECT = 'SELECT '.TBL_PERSONS.'.id AS id_person,'.TBL_PERSONS.'.position, '.TBL_PERSONS.'.firstname AS first, '.TBL_PERSONS.'.lastname AS last, '.TBL_LINEUP.'.id_club, '.TBL_LINEUP.'.type, '.TBL_LINEUP.'.captain, SUBSIN.subs_min AS subsmin_in, SUBSOUT.subs_min AS subsmin_out 
			   FROM '.TBL_LINEUP.'
			   JOIN '.TBL_PERSONS.' ON '.TBL_LINEUP.'.id_person = '.TBL_PERSONS.'.id
			   LEFT JOIN '.TBL_SUBS.' AS SUBSIN ON '.TBL_LINEUP.'.id_person = SUBSIN.id_person_in AND '.TBL_LINEUP.'.id_match = SUBSIN.id_match
			   LEFT JOIN '.TBL_SUBS.' AS SUBSOUT ON '.TBL_LINEUP.'.id_person = SUBSOUT.id_person_out AND '.TBL_LINEUP.'.id_match = SUBSOUT.id_match
			   WHERE '.TBL_LINEUP.'.id_match = '.$id.' ORDER BY '.TBL_PERSONS.'.position, '.TBL_PERSONS.'.lastname';				 
	$rooster = runSQL($SELECT);


	$SELECT = 'SELECT C.id, C.shortname, C.longname, C.aka, C.type, C.range, C.country, C.creation, C.website, C.imgurl, C.plot, S.season
			   FROM '.TBL_COMPETITIONS.' AS C 
			   JOIN '.TBL_DAYS.' AS D ON D.id_compet = C.id 
			   JOIN '.TBL_SEASONS.' AS S ON S.id = D.id_season
			   JOIN '.TBL_MATCHS.' AS M ON M.id_day = D.id
			   WHERE M.id = '.$id;				 
	$competdata = runSQL($SELECT);
	
	
    // existing id?
    if (!count($res)) redirect('competitions.php');
    
    // get the item
    $matchs = $res[0];
	//get additionals caracs 
	$matchs['carac_ads'] = get_carac('5',$id);
	
	
    // is it editable/ copyable?
    $editable = localnet();
   
    // multi-user permissions
    if ($config['multiuser'])
    {
        $editable = check_permission(PERM_WRITE, $_COOKIE['PCSuserid']);
		if ($config['activecomments']) {
		$commentable = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $seegallery = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
		}
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($res[0]['id_compet'], $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}


$smarty->assign('cards', $cards);
$smarty->assign('competition', $competdata[0]);
$smarty->assign('rooster', $rooster);
$smarty->assign('goleadors', $goleadors);
$smarty->assign('day', $day);
$smarty->assign('season', $res[0]['id_season']);
$smarty->assign('haveseason', $res[0]['id_season']);
$smarty->assign('editable', $editable);
$smarty->assign('commentable', $commentable);
$smarty->assign('prev_id', $prev_id);
$smarty->assign('next_id', $next_id);
$smarty->assign('seegallery', $seegallery);
$smarty->assign('actiontitle', $competdata[0]['longname'] .' - ' .$competdata[0]['season'] . '/' . ($competdata[0]['season']+1));

// prepare templates
tpl_page('detailview', $matchs['name']);
tpl_show_match($matchs,$competdata[0]['id'],$competdata[0]['type']);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('actions_competitions.tpl', $id);
smarty_display('show_match.tpl', $res[0]['id_compet']);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_match'.$id, httpCacheCaptureEnd());
}

?>
