<?php
/**
 * Table Detail View
 *
 * Shows table for a competition
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_tables.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($competition)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_COMPETITIONS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$competition)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$competition = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($competition)) redirect('show_competitions.php');
}

// get data (id may be empty on a empty database)
if (!empty($competition))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('competitions.id = '.$competition);
        exit;
    }


$SELECT = 'SELECT count(*) as numday FROM '.TBL_DAYS.' WHERE id_compet = '.$competition.' AND id_season = '.$season; 
$ret   = runSQL($SELECT);	
$numdays = $ret[0]['numday'];	
	
$SELECT = 'SELECT id, shortname, longname, aka, active, oneyear, country, creation, website, imgurl, owner_id, plot FROM '.TBL_COMPETITIONS.' WHERE '.TBL_COMPETITIONS.'.id = \''.$competition.'\';'; 
$res   = runSQL($SELECT);	
$competition = $res[0];

$SELECT = 'SELECT * from '.TBL_PARAMS.' WHERE id_season='.$season.' AND id_compet='.$competition['id'];
$params   = runSQL($SELECT);

$SELECT = 'SELECT '.TBL_SEASONS.'.season FROM '.TBL_SEASONS.' WHERE id = '.$season;				 
$nameseason = runSQL($SELECT);


$lastday = runSQL('SELECT '.TBL_DAYS.'.id, '.TBL_DAYS.'.day FROM '.TBL_DAYS.' WHERE '.TBL_DAYS.'.date_day <= NOW() AND id_compet='.$competition['id'].' AND id_season='.$season.' ORDER BY '.TBL_DAYS.'.date_day DESC LIMIT 1');
$maxday = $lastday[0]['day'];
if (!$day) {
	$day = $lastday[0]['day'];
	$maxday = $lastday[0]['day'];
}
else {
	$maxday = $lastday[0]['day'];
}
if (!$lastday) {
	$day = 1;
	$maxday = 1;
}
else if ($day > $lastday[0]['day']) {
	$day = $lastday[0]['day'];
	$maxday = $lastday[0]['day'];
}	

if ($club) {$WHERES = ' AND '.TBL_GOALS.'.id_club = '.$club;}
if (!$limit) {$limit = 15;}

if ($day) {
$SELECT = 'SELECT count('.TBL_GOALS.'.id) as goals, sum('.TBL_GOALS.'.goal_pen) as penalty, '.TBL_GOALS.'.id_person, '.TBL_PERSONS.'.lastname, '.TBL_PERSONS.'.firstname, '.TBL_CLUBS.'.shortname, '.TBL_GOALS.'.id_club 
FROM '.TBL_GOALS.' 
JOIN '.TBL_MATCHS.' ON '.TBL_MATCHS.'.id = '.TBL_GOALS.'.id_match
JOIN '.TBL_DAYS.' ON '.TBL_DAYS.'.id = '.TBL_MATCHS.'.id_day
JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_GOALS.'.id_person
JOIN '.TBL_CLUBS.' ON '.TBL_CLUBS.'.id = '.TBL_GOALS.'.id_club
WHERE '.TBL_DAYS.'.id_compet = '.$competition['id'].' AND '.TBL_DAYS.'.id_season = '.$season.' AND '.TBL_DAYS.'.day <= '.$day.' AND '.TBL_GOALS.'.goal_csc = 0 '.$WHERES.'
GROUP BY '.TBL_GOALS.'.id_person ORDER BY goals DESC LIMIT '.$limit;
	
$kickers   = runSQL($SELECT);
}

$SELECT = 'SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname as clubname
           FROM '.TBL_CANDIDATES.'
		   JOIN '.TBL_CLUBS.' ON '.TBL_CLUBS.'.id = '.TBL_CANDIDATES.'.id_club
           WHERE '.TBL_CANDIDATES.'.id_compet = '.$competition['id'].' AND '.TBL_CANDIDATES.'.id_season='.$season.' ORDER BY clubname';				 
$candidates = runSQL($SELECT);
	
//VIEW PAGE CONFIGURATION
	
    // is it editable/ copyable?
    //$editable = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $administrable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$owners = split(',', $competition['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$editable = 1;
			}
		}
		if ($config['activecomments']) {
		$commentable = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $seegallery = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
		}        
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

if (!$season) {$season = $config['seasonfilterdefault'];}
if ($config['competitionstats'] && $competition['active']) {
$smarty->assign('statsactive', 1);
}

$smarty->assign('season', $season);
$smarty->assign('administrable', $administrable);
$smarty->assign('editable', $editable);
$smarty->assign('commentable', $commentable);
$smarty->assign('prev_id', $prev_id);
$smarty->assign('next_id', $next_id);
$smarty->assign('seegallery', $seegallery);
$smarty->assign('actiontitle', $competition['longname']);
$smarty->assign('kickers', $kickers);
$smarty->assign('candidates', $candidates);
$smarty->assign('club', $club);
$smarty->assign('limit', $limit);
$smarty->assign('numdays', $numdays);
$smarty->assign('day', $day);
$smarty->assign('maxday', $maxday);
$smarty->assign('params', $params[0]);
$smarty->assign('nameseason', $nameseason[0]);

// prepare templates
tpl_page('detailview', $competition['name']);
if (!empty($competition)) tpl_show_tables($competition);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();


if (!empty($competition)) smarty_display('actions_competitions.tpl', $competition);
if (!empty($competition)) smarty_display('show_kickers.tpl', $competition);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_kickers'.$competition['id'], httpCacheCaptureEnd());
}

?>
