<?php
/**
 * Competition Detail View
 *
 * Shows all data for competitions
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_competitions.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_COMPETITIONS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('show_competitions.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

if (!$season) {$season = $config['seasonfilterdefault'];}

$SELECT = 'SELECT CO.id, CO.shortname, SCO.shortname AS subshortname, CO.longname, CO.active, CO.aka, CO.type, CO.range, CO.oneyear, CO.country, CO.creation, CO.complete, CO.website, CO.imgurl, CO.owner_id, CO.plot 
		   FROM '.TBL_COMPETITIONS.' AS CO
		   LEFT JOIN '.TBL_COMPETITIONS.' AS SCO ON CO.subcompet = SCO.id		   
		   WHERE CO.id = \''.$id.'\';'; 
$res   = runSQL($SELECT);

$SELECT = 'SELECT id, shortname, longname, aka, type, range, oneyear, country, creation, website, imgurl, owner_id, plot FROM '.TBL_COMPETITIONS.' WHERE subcompet = \''.$res[0]['id'].'\' ORDER BY subpos, shortname;'; 
$subcompet   = runSQL($SELECT);

if (!$subcompet) {
	$SELECT = 'SELECT count('.TBL_PRIZELIST.'.id_season) AS count, '.TBL_PRIZELIST.'.id_club, '.TBL_CLUBS.'.shortname
				FROM '.TBL_PRIZELIST.'
				JOIN '.TBL_CLUBS.' ON '.TBL_PRIZELIST.'.id_club = '.TBL_CLUBS.'.id 
				WHERE '.TBL_PRIZELIST.'.id_compet = '.$id.' 
				GROUP BY '.TBL_PRIZELIST.'.id_club
				ORDER BY count DESC';
	$prizelisting = runSQL($SELECT);
	foreach ($prizelisting as $prize) {
	$prizelist[$prize['count']]['count'] = $prize['count'];
	$prizelist[$prize['count']]['list'] .= $prize['shortname'].', ';	
	}
}
$smarty->assign('prizelist', $prizelist);

$SELECT = 'SELECT id, season FROM '.TBL_SEASONS.' ORDER BY season DESC '.$LIMIT;
$seasons = runSQL($SELECT);

    // existing id?
    if (!count($res)) redirect('competitions.php');
    
    // get the item
    $competition = $res[0];
	//get additionals caracs 
	$competition['carac_ads'] = get_carac('2',$id);
	$competdata['type'] = $competition['type'];
	
	

	
    // is it editable/ copyable?
    //$editable = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $administrable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$owners = split(',', $res[0]['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$editable = 1;
			}
			if($owner) {
				$SELECT = 'SELECT id, name FROM '.TBL_USERS.' WHERE id='.$owner;
				$admname = runSQL($SELECT);
				$listadmin = array_merge ($listadmin, $admname);
			}
		}
		$smarty->assign('listadmin', $listadmin);
		if ($config['activecomments']) {
		$commentable = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $seegallery = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
		}
        
    }

    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

if ($competition['subshortname']) {$actiontitle = $competition['subshortname'].' - '.$competition['longname'];}
else {$actiontitle = $competition['longname'];}

if ($config['competitionstats'] && $competition['active']) {
$smarty->assign('statsactive', 1);
}

$smarty->assign('season', $season);
$smarty->assign('seasons', $seasons);
$smarty->assign('editable', $editable);
$smarty->assign('administrable', $administrable);
$smarty->assign('commentable', $commentable);
$smarty->assign('competdata', $competdata);
$smarty->assign('prev_id', $prev_id);
$smarty->assign('next_id', $next_id);
$smarty->assign('seegallery', $seegallery);
$smarty->assign('actiontitle', $actiontitle);
$smarty->assign('members', $members);

// prepare templates
tpl_page('detailview', $competition['name']);
if (!empty($id)) tpl_show_competitions($competition, $subcompet,$season);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
if (!empty($id)) smarty_display('actions_competitions.tpl', $id);
if (!empty($id)) smarty_display('show_competitions.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_competitions'.$id, httpCacheCaptureEnd());
}

?>
