<?php
/**
 * Clubs Detail View
 *
 * Shows all data for clubs
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_clubs.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_CLUBS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('clubs.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('clubs.id = '.$id);
        exit;
    }

$SELECT = 'SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname, '.TBL_CLUBS.'.longname, '.TBL_CLUBS.'.aka, '.TBL_CLUBS.'.country, '.TBL_CLUBS.'.city, '.TBL_CLUBS.'.imgurl, '.TBL_CLUBS.'.creation, '.TBL_CLUBS.'.complete, '.TBL_CLUBS.'.website,  '.TBL_CLUBS.'.email, '.TBL_CLUBS.'.adresse, '.TBL_CLUBS.'.tel, '.TBL_CLUBS.'.fax, '.TBL_CLUBS.'.newspaper, '.TBL_CLUBS.'.owner_id, '.TBL_CLUBS.'.id_stadium as stadium_id, '.TBL_STADIUMS.'.longname as stadium, '.TBL_CLUBS.'.id_president as president_id, CONCAT('.TBL_PERSONS.'.firstname, " ", '.TBL_PERSONS.'.lastname) AS president, '.TBL_CLUBS.'.plot 
			FROM '.TBL_CLUBS.'
			LEFT JOIN '.TBL_STADIUMS.' ON '.TBL_STADIUMS.'.id = '.TBL_CLUBS.'.id_stadium
			LEFT JOIN '.TBL_PERSONS.' ON '.TBL_PERSONS.'.id = '.TBL_CLUBS.'.id_president
			WHERE '.TBL_CLUBS.'.id = \''.$id.'\';';
$res   = runSQL($SELECT);

$SELECT = 'SELECT P.id_compet, P.id_season, C.shortname, C.range, C.oneyear, S.season
		   FROM '.TBL_PRIZELIST.' AS P
		   LEFT JOIN '.TBL_COMPETITIONS.' AS C ON P.id_compet = C.id
		   LEFT JOIN '.TBL_SEASONS.' AS S ON P.id_season = S.id
		   WHERE P.id_club = '.$id.' ORDER BY S.season';				 
$prizelist = runSQL($SELECT);

$SELECT = 'SELECT DISTINCT P.id_compet, C.shortname
		   FROM '.TBL_PRIZELIST.' AS P
		   LEFT JOIN '.TBL_COMPETITIONS.' AS C ON P.id_compet = C.id
		   WHERE P.id_club = '.$id;				 
$prizes = runSQL($SELECT);

$smarty->assign('prizes', $prizes);
$smarty->assign('prizelist', $prizelist); 
    // get the item
    $club = $res[0];
	//get additionals caracs 
	$club['carac_ads'] = get_carac('1',$id);	
	
    // is it editable/ copyable?
    //$club['editable'] = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $club['administrable'] = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$owners = split(',', $res[0]['owner_id']);

		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$club['editable'] = 1;
				
			}
			if($owner) {
			$SELECT = 'SELECT id, name FROM '.TBL_USERS.' WHERE id='.$owner;
			$admname = runSQL($SELECT);
			$listadmin = array_merge ($listadmin, $admname);
			}
		}

		$smarty->assign('listadmin', $listadmin);
		if ($config['activecomments']) {
		$club['commentable'] = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $club['seegallery'] = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
        }
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $club['prev_id'] = ($key > 0) ? $ids[$key-1] : 0;
            $club['next_id'] = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}


$smarty->assign('clubstats', $config['clubstats']);

// prepare templates
tpl_page('detailview', $club['name']);
if (!empty($id)) tpl_show_clubs($club);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
if (!empty($id)) smarty_display('show_clubs.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_clubs'.$id, httpCacheCaptureEnd());
}

?>
