<?php
/**
 * categorie Detail View
 *
 * Shows all data for categories
 *
 * @package PHP categorie System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_categories.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_CATEGORIES.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('show_categories.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('categories.id = '.$id);
        exit;
    }


$SELECT = 'SELECT id, shortname, longname, country, pos, parent, imgurl, plot FROM '.TBL_CATEGORIES.' WHERE '.TBL_CATEGORIES.'.id = \''.$id.'\';'; 
$res   = runSQL($SELECT);

$SELECT = 'SELECT id, shortname, longname, country, category, imgurl, plot FROM '.TBL_COMPETITIONS.' WHERE '.TBL_COMPETITIONS.'.category = \''.$id.'\';'; 
$competitions   = runSQL($SELECT);

    // existing id?
    if (!count($res)) redirect('categories.php');
	if (count($competitions) == 1) {redirect('show_competitions.php?id='.$competitions[0]['id']);}
    
    // get the item
    $categorie = $res[0];

	
	
    // is it editable/ copyable?
    $editable = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $editable = check_permission(PERM_WRITE, $_COOKIE['PCSuserid']);
		if ($config['activecomments']) {
		$commentable = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $seegallery = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
		}
        
    }

    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

if (!$season) {$season = $config['seasonfilterdefault'];}
$smarty->assign('season', $season);
$smarty->assign('seasons', $seasons);
$smarty->assign('editable', $editable);
$smarty->assign('commentable', $commentable);
$smarty->assign('competitions', $competitions);
$smarty->assign('prev_id', $prev_id);
$smarty->assign('next_id', $next_id);
$smarty->assign('seegallery', $seegallery);
$smarty->assign('actiontitle', $categorie['longname']);

// prepare templates
tpl_page('detailview', $categorie['name']);
if (!empty($id)) tpl_show_categories($categorie, $competitions);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
if (!empty($id)) smarty_display('actions_categories.tpl', $id);
if (!empty($id)) smarty_display('show_categories.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_categories'.$id, httpCacheCaptureEnd());
}

?>
