<?php
/**
 * Calendar team Detail View
 *
 * Shows all date for a team
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: show_calendarteams.php,v 1.00 2006/10/26 19:47:13
 */

require_once './core/functions.php';


// random view
if (empty($id)) 
{
	$count  = 0;
    $all    = strtoupper($lang['radio_all']);
    $WHERES = '';
    
    // find a random id
    $SELECT = 'SELECT id, REVERSE(RAND(NOW())) AS rnd
                 FROM '.TBL_CLUBS.'
                '.$WHERES.'
                ORDER BY rnd
                LIMIT 1';

	while (!$id)
	{
		$result = runSQL($SELECT);
        
        // prevent endless loop
        if (!count($result) || ($count++ > 50)) break;
        
		$id = $result[0]['id'];
	}
    
	// id still empty? go back to index.
	if (empty($id)) redirect('clubs.php');
}

// get data (id may be empty on a empty database)
if (!empty($id))
{

    // XML export?
    if (($export == 'xml') && $config['xml'])
    {
        require_once './core/'.$export.'.php';
        xmlexport('clubs.id = '.$id);
        exit;
    }


if (!$season) {$season = $config['seasonfilterdefault'];}
$smarty->assign('season', $season);

$SELECT = 'SELECT '.TBL_CLUBS.'.id, '.TBL_CLUBS.'.shortname, '.TBL_CLUBS.'.longname, ST.longname as stadium, '.TBL_CLUBS.'.city, '.TBL_CLUBS.'.aka, '.TBL_CLUBS.'.country, '.TBL_CLUBS.'.creation, '.TBL_CLUBS.'.website, '.TBL_CLUBS.'.adresse, '.TBL_CLUBS.'.tel, '.TBL_CLUBS.'.owner_id, '.TBL_CLUBS.'.fax, '.TBL_CLUBS.'.newspaper, '.TBL_CLUBS.'.imgurl 
		   FROM '.TBL_CLUBS.' 
		   LEFT JOIN '.TBL_STADIUMS.' AS ST ON '.TBL_CLUBS.'.id_stadium = ST.id
		   WHERE '.TBL_CLUBS.'.id = \''.$id.'\';'; 
$res   = runSQL($SELECT);

$SELECT = 'SELECT CO.id, CO.shortname, SCO.shortname AS subshortname 
		   FROM '.TBL_CANDIDATES.' 
		   JOIN '.TBL_COMPETITIONS.' AS CO ON '.TBL_CANDIDATES.'.id_compet = CO.id
		   LEFT JOIN '.TBL_COMPETITIONS.' AS SCO ON CO.subcompet = SCO.id
		   WHERE '.TBL_CANDIDATES.'.id_season = '.$season.' AND '.TBL_CANDIDATES.'.id_club='.$id.';'; 
$competitions   = runSQL($SELECT);


$SELECT = 'SELECT '.TBL_MATCHS.'.id, C1.id AS dom_id, C1.shortname AS domteam, C2.shortname AS extteam, C2.id AS ext_id, '.TBL_DAYS.'.day, '.TBL_DAYS.'.id_compet, '.TBL_MATCHS.'.date_day, DATEDIFF(NOW(), '.TBL_MATCHS.'.date_day) as datediff, '.TBL_MATCHS.'.validation, '.TBL_MATCHS.'.buts_dom , '.TBL_MATCHS.'.buts_ext
		   FROM '.TBL_MATCHS.' 
		   JOIN '.TBL_CLUBS.' AS C1 ON C1.id = '.TBL_MATCHS.'.id_candidate_dom 
		   JOIN '.TBL_CLUBS.' AS C2 ON C2.id = '.TBL_MATCHS.'.id_candidate_ext 
		   JOIN '.TBL_DAYS.' ON '.TBL_MATCHS.'.id_day = '.TBL_DAYS.'.id 
		   WHERE ('.TBL_MATCHS.'.id_candidate_dom = '.$id.' OR '.TBL_MATCHS.'.id_candidate_ext = '.$id.') AND '.TBL_DAYS.'.id_season = '.$season.' ORDER BY '.TBL_DAYS.'.day;'; 
$calendar   = runSQL($SELECT);



$smarty->assign('competitions', $competitions);			 
$smarty->assign('matchvalidation', $config['matchvalidation']);

    // existing id?
    if (!count($res)) redirect('clubs.php');
    
    // get the item
    $club = $res[0];
	
	
    // is it editable/ copyable?
    //$club['editable'] = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $club['administrable'] = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$owners = split(',', $res[0]['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$club['editable'] = 1;
			}
		}
		if ($config['activecomments']) {
		$club['commentable'] = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $club['seegallery'] = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
        }        
    }


    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $club['prev_id'] = ($key > 0) ? $ids[$key-1] : 0;
            $club['next_id'] = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }
}

$smarty->assign('clubstats', $config['clubstats']);
// prepare templates
tpl_page('detailview', $club['name']);
tpl_show_calendarteams($club, $calendar);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    httpCacheCaptureStart();
}

// display templates
smarty_display('header.tpl');
if (!$config['http_caching']) flush();
smarty_display('show_calendarteams.tpl', $id);
smarty_display('footer.tpl');

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('show_calendarteams'.$id, httpCacheCaptureEnd());
}

?>
