<?php
/**
 * Setup page
 *
 * Handles saving of the various config options.
 *
 * @package Setup
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: setup.php,v 1.00 2006/12/05 18:15:00
 */
 
require_once './core/session.php';
require_once './core/functions.php';
require_once './core/setupfunctions.php';

localnet_or_die();
permission_or_die(PERM_ADMIN);





// save data
if ($save)
{
    $languageflags  = @join('::', $languages);


	// insert data
	foreach ($SETUP_GLOBAL as $opt)
	{
		$SQL = 'REPLACE INTO '.TBL_CONFIG." (opt,value) VALUES ('$opt','".addslashes($$opt)."')";
        runSQL($SQL);
    }
    
   
    // update session variables
    update_session();
    
    // remove user-specific config options
	//$user_id = $_COOKIE['PCSuserid'];
	//if (!empty($user_id))
	//{  
    //    $SQL = "DELETE FROM ".TBL_USERCONFIG." WHERE user_id = '".addslashes($user_id)."'";
    //    runSQL($SQL);
	//}
	// reload config
	loadconfig(true);
} 



// check permissions again - they may have changed
if (!check_permission(PERM_ADMIN))
{
    redirect('login.php');
}

// destroy cookies if required
if ($_COOKIE['PCSusername'] &! $config['multiuser'])
{
    setcookie('PCSpassword', '', time()-7200);
    setcookie('PCSusername', '', time()-7200);
    setcookie('PCSuserid',   '', time()-7200);
}

// cache maintenance
list($total, $expired, $files) = analyzeCacheFolder('cache/imdb', !empty($cacheempty));

if ($total)
{
	// delete from cache directory?
	if ($cachecleanup || $cacheempty)
	{
		foreach ($files as $file) unlink($file);
		$total  -= $expired;
		$expired = 0;
	}

	$smarty->assign('total',   round($total/(1024*1024), 2));
	$smarty->assign('expired', round($expired/(1024*1024), 2));
}

// prepare options
$setup = setup_mkOptions(false);
// prepare templates
tpl_page('configview');
$smarty->assign('setup', $setup);
// display templates
tpl_display('setup.tpl');

?>
