<?php
/**
 * Browse View
 *
 * 
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: pronostics.php,v 1.00 2006/10/22 18:15:00
 */
 
require_once './core/session.php';
require_once './core/functions.php';
require_once './core/output.php';

$user_id = $_COOKIE['PCSuserid'];

// This checks to see if user has selected the New items
// (This is seperately assigned as a LIMIT so, if this
// exists, lets just skip page numbers and carry on
if (!$LIMIT && ($config['pageno'] > 0))
{
    // check Page Number
    if (!isset($pageno))
    {
        $pageno = 1;
    }

	// define Max Results Per Page
	$maxresults = $config['pageno'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	
	
// get total amount of results from DB
	$totalresults = runSQL('SELECT '.TBL_BETWINNER.'.user_id AS user_id, '.TBL_USERS.'.name AS name, SUM('.TBL_BETWINNER.'.goodprono) AS goodprono , SUM('.TBL_BETWINNER.'.prize) AS prize
							FROM '.TBL_BETWINNER.'
							JOIN '.TBL_USERS.' ON '.TBL_USERS.'.id = '.TBL_BETWINNER.'.user_id
							JOIN '.TBL_BETTABLE.' ON '.TBL_BETTABLE.'.id = '.TBL_BETWINNER.'.id_bettable
						    WHERE '.TBL_BETTABLE.'.date_fin_bet < "2007-10-01 00:00"
						    GROUP BY '.TBL_BETWINNER.'.user_id');
 
// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
}
    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned


if (!$order) {$order=3;}
$smarty->assign('order', $order);
switch($order) {
	case 1:	$ORDER = "ORDER BY name ASC"; break;
	case 2:	$ORDER = "ORDER BY numprono DESC"; break;
	case 3:	$ORDER = "ORDER BY goodprono DESC"; break;
	case 4:	$ORDER = "ORDER BY prize DESC"; break;
	default: $ORDER = "ORDER BY goodprono DESC";
}#end switch


//distinct month
$select = 'SELECT DISTINCT(MONTH(date_fin_bet)) AS mymonth FROM '.TBL_BETTABLE;
$mymonth = runSQL($select);
$smarty->assign('mymonth', $mymonth);

//distinct year
$select = 'SELECT DISTINCT(YEAR(date_fin_bet)) AS myyear FROM '.TBL_BETTABLE;
$myyear = runSQL($select);
$smarty->assign('myyear', $myyear);

if (!$orderyear) {$orderyear = date('Y');}
if ($ordermonth) {
$WHERE = 'WHERE YEAR('.TBL_BETTABLE.'.date_fin_bet) = '.$orderyear.' AND MONTH('.TBL_BETTABLE.'.date_fin_bet) = '.$ordermonth;
}
else {
$WHERE = 'WHERE YEAR('.TBL_BETTABLE.'.date_fin_bet) = "'.$orderyear.'"';
}
$smarty->assign('orderyear', $orderyear);
$smarty->assign('ordermonth', $ordermonth);


// do hard work
$select = 'SELECT '.TBL_BETWINNER.'.user_id AS user_id, '.TBL_USERS.'.name AS name, COUNT('.TBL_BETWINNER.'.id) AS numprono, SUM('.TBL_BETWINNER.'.goodprono) AS goodprono , SUM('.TBL_BETWINNER.'.prize) AS prize
		   FROM '.TBL_BETWINNER.'
		   JOIN '.TBL_USERS.' ON '.TBL_USERS.'.id = '.TBL_BETWINNER.'.user_id
		   JOIN '.TBL_BETTABLE.' ON '.TBL_BETTABLE.'.id = '.TBL_BETWINNER.'.id_bettable
		   '.$WHERE.'
		   GROUP BY '.TBL_BETWINNER.'.user_id '.$ORDER.' '.$LIMIT;
$result = runSQL($select);
$smarty->assign('number', count($result));


// store query result in session for prev/next navigation
$_SESSION['pcs']['query_result'] = array_map(create_function('&$row', 'return $row["id"];'), $result);

// multi-user permissions
    if ($config['multiuser'])
    {
        $editable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$smarty->assign('editable', $editable);
    }

//DISPLAY PAGE

// prepare
tpl_page('pronostics');
tpl_list($result);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    cache_start('index');
}

// allow XML and RSS export
if ($config['xls']) $smarty->assign('xls', 'index.php?');
if ($config['xml']) $smarty->assign('xml', 'index.php?');
if ($config['pdf']) $smarty->assign('pdf', 'index.php?');
if ($config['rss']) $smarty->assign('rss', 'index.php?');

$smarty->assign('action', 'prono_table');
// display templates
smarty_display('header.tpl');
smarty_display('filters_pronostics.tpl');
smarty_display('actions_pronostics.tpl');
if (!$config['http_caching']) flush();

smarty_display('list_prono_table.tpl');
smarty_display('footer.tpl');

// caching enabled?
if ($config['httpcaching'])
{
    httpCacheOutput('pronostics', httpCacheCaptureEnd());
} 
?>