<?php
/**
 * Browse View
 *
 * 
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: pronostics.php,v 1.00 2006/10/22 18:15:00
 */
 
require_once './core/session.php';
require_once './core/functions.php';
require_once './core/output.php';

$user_id = $_COOKIE['PCSuserid'];

// default order
if (!$ORDER)  {
	$ORDER   = TBL_BETTABLE.'.title';
}

//distinct month
$select = 'SELECT DISTINCT(MONTH(date_fin_bet)) AS mymonth FROM '.TBL_BETTABLE;
$mymonth = runSQL($select);
$smarty->assign('mymonth', $mymonth);

//distinct year
$select = 'SELECT DISTINCT(YEAR(date_fin_bet)) AS myyear FROM '.TBL_BETTABLE;
$myyear = runSQL($select);
$smarty->assign('myyear', $myyear);

if (!$orderyear) {$orderyear = date('Y');}
if ($ordermonth) {
$WHERE = 'AND YEAR('.TBL_BETTABLE.'.date_fin_bet) = '.$orderyear.' AND MONTH('.TBL_BETTABLE.'.date_fin_bet) = '.$ordermonth;
}
else {
$WHERE = 'AND YEAR('.TBL_BETTABLE.'.date_fin_bet) = "'.$orderyear.'"';
}
$smarty->assign('orderyear', $orderyear);
$smarty->assign('ordermonth', $ordermonth);

// This checks to see if user has selected the New items
// (This is seperately assigned as a LIMIT so, if this
// exists, lets just skip page numbers and carry on
if (!$LIMIT && ($config['pageno'] > 0))
{
    // check Page Number
    if (!isset($pageno))
    {
        $pageno = 1;
    }

	// define Max Results Per Page
	$maxresults = $config['pageno'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	
	
// get total amount of results from DB
	$totalresults = runSQL('SELECT count(*) AS num 
							FROM '.TBL_BETTABLE.' WHERE (TIMEDIFF('.TBL_BETTABLE.'.date_fin_bet, NOW()) < 0 OR DATEDIFF('.TBL_BETTABLE.'.date_fin_bet, NOW()) < 0) '.$WHERE);
 
// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
}
    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned



// do hard work
$select = 'SELECT '.TBL_BETTABLE.'.id, '.TBL_BETTABLE.'.title, '.TBL_BETTABLE.'.nbr_prono,  '.TBL_BETTABLE.'.date_deb,  '.TBL_BETTABLE.'.date_fin, '.TBL_BETTABLE.'.paybet, '.TBL_BETWINNER.'.goodprono, '.TBL_BETWINNER.'.prize
		   FROM '.TBL_BETTABLE.'
		   LEFT JOIN '.TBL_BETWINNER.' ON '.TBL_BETWINNER.'.id_bettable = '.TBL_BETTABLE.'.id AND '.TBL_BETWINNER.'.user_id = '.$user_id.'
		    WHERE (TIMEDIFF('.TBL_BETTABLE.'.date_fin_bet, NOW()) < 0 OR DATEDIFF('.TBL_BETTABLE.'.date_fin_bet, NOW()) < 0) '.$WHERE.' ORDER BY '.TBL_BETTABLE.'.date_deb DESC '.$LIMIT;
$result = runSQL($select);


$smarty->assign('number', count($result));


// store query result in session for prev/next navigation
$_SESSION['pcs']['query_result'] = array_map(create_function('&$row', 'return $row["id"];'), $result);

// multi-user permissions
    if ($config['multiuser'])
    {
        $editable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$smarty->assign('editable', $editable);
    }

//DISPLAY PAGE

// prepare
tpl_page('pronostics');
tpl_list($result);
tpl_filters_clubs($filter, $countryfilter);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    cache_start('index');
}

// allow XML and RSS export
if ($config['xls']) $smarty->assign('xls', 'index.php?');
if ($config['xml']) $smarty->assign('xml', 'index.php?');
if ($config['pdf']) $smarty->assign('pdf', 'index.php?');
if ($config['rss']) $smarty->assign('rss', 'index.php?');

// display templates
smarty_display('header.tpl');
smarty_display('filters_pronostics.tpl');
smarty_display('actions_pronostics.tpl');
if (!$config['http_caching']) flush();

smarty_display('list_prono_results.tpl');
smarty_display('footer.tpl');

// caching enabled?
if ($config['httpcaching'])
{
    httpCacheOutput('pronostics', httpCacheCaptureEnd());
} 
?>