<?php
/**
 * Profile page
 *
 * Handles saving of the various config options for the user.
 *
 * @package Setup
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: profile.php,v 1.00 2006/10/22 18:15:00
 */
 
require_once './core/session.php';
require_once './core/functions.php';
require_once './core/setupfunctions.php';

$user_id = $_COOKIE['PCSuserid'];


if (empty($user_id))
{
	errorpage($lang['accessdenied']);
}

// change theme?
if (!empty($changetheme))
{
    $INSERT = "REPLACE INTO ".TBL_USERCONFIG." (user_id, opt, value) VALUES ('".addslashes($user_id)."', 'template', '".addslashes($newtheme)."')";
	runSQL($INSERT);

	// update session variables
    update_session();
	// reload config
	loadconfig();

redirect($_SERVER['HTTP_REFERER']);	
}

// save use data
if ($editsave)
{

	if ($email) {
		$SETS = "email = '".addslashes($email)."'";
	}
	if ($password && ($password == $password2)) {
		$SETS = "passwd = '".md5($password)."'";
	}
	$INSERT = 'UPDATE '.TBL_USERS.' SET '.$SETS.' WHERE id = '.$user_id;
	runSQL($INSERT);
	
	// update session variables
    update_session();
	// reload config
	loadconfig(true);
	
	redirect('profile.php');

}

// save data
if ($save)
{
    // convert languages array back into string
	$languageflags = @join('::', $languages);
    
	// insert data
	foreach ($SETUP_USER as $opt) 
    {
		if ($opt == 'avatar') {
			if ($$opt = setup_upload($opt, 'cache/img/users/logo_',$user_id)) {			
			$SQL = "REPLACE INTO ".TBL_USERCONFIG." (user_id, opt, value) VALUES ('".addslashes($user_id)."', '$opt', '".addslashes($$opt)."')";
			runSQL($SQL);
			}
		}
		else if ($opt == 'birthday') {
			if ($$opt = getusdate($$opt)) {			
			$SQL = "REPLACE INTO ".TBL_USERCONFIG." (user_id, opt, value) VALUES ('".addslashes($user_id)."', '$opt', '".addslashes($$opt)."')";
			runSQL($SQL);
			}
		}
		else {
        $SQL = "REPLACE INTO ".TBL_USERCONFIG." (user_id, opt, value) VALUES ('".addslashes($user_id)."', '$opt', '".addslashes($$opt)."')";
		runSQL($SQL);
		}
	}

    // update session variables
    update_session();
	// reload config
	loadconfig(true);
   
}


$SELECT = 'SELECT '.TBL_USERS.'.id, '.TBL_USERS.'.name, '.TBL_USERS.'.email, '.TBL_USERCONFIG.'.value AS avatar 
		  FROM '.TBL_USERS.'
		  LEFT JOIN '.TBL_USERCONFIG.' ON '.TBL_USERS.'.id = '.TBL_USERCONFIG.'.user_id AND '.TBL_USERCONFIG.'.opt = \'avatar\'
		  WHERE '.TBL_USERS.'.id = \''.$user_id.'\';';
$user   = runSQL($SELECT);



// prepare options
$setup = setup_mkOptions(true);

// prepare templates
tpl_page('profile');
$smarty->assign('setup', $setup);
$smarty->assign('user', $user[0]);
$smarty->assign('permadmin', check_permission(PERM_ADMIN,$user_id));
$smarty->assign('permreadall', check_permission(PERM_READALL,$user_id));
$smarty->assign('permwriteall', check_permission(PERM_WRITEALL,$user_id));
$smarty->assign('permwrite', check_permission(PERM_WRITE,$user_id));
$smarty->assign('permmkcomment', check_permission(PERM_MKCOMMENT,$user_id));
$smarty->assign('permgallery', check_permission(PERM_GALLERY,$user_id));
$smarty->assign('permaddgallery', check_permission(PERM_ADDGALLERY,$user_id));

// display templates
tpl_display('profile.tpl');

?>