<?php
/**
 * Clubs View
 *
 * 
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: index.php,v 1.00 2006/10/22 18:15:00
 */
 
require_once './core/session.php';
require_once './core/functions.php';
require_once './core/output.php';


if (!$competition) {redirect('competitions.php');}
$id = $competition;

//VIEW PAGE CONFIGURATION

$SELECT = 'SELECT id, shortname, longname, active, aka, type, range, oneyear, country, creation, website, imgurl, owner_id, plot FROM '.TBL_COMPETITIONS.' WHERE '.TBL_COMPETITIONS.'.id = \''.$id.'\';'; 
$res   = runSQL($SELECT);	
$competition = $res[0];
	
    // is it editable/ copyable?
    //$editable = localnet();
    
    // multi-user permissions
    if ($config['multiuser'])
    {
        $administrable = check_permission(PERM_ADMIN, $_COOKIE['PCSuserid']);
		$owners = split(',', $res[0]['owner_id']);
		foreach($owners as $owner) {
			if($owner == $_COOKIE['PCSuserid']) {
				$editable = 1;
			}
		}
		if ($config['activecomments']) {
		$commentable = check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']);
		}
		if ($config['activegallery']) {
        $seegallery = check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']);
		}        
    }





$WHERES = 'WHERE id_compet =\''.$id.'\''; 

// This checks to see if user has selected the New items
// (This is seperately assigned as a LIMIT so, if this
// exists, lets just skip page numbers and carry on
if (!$LIMIT && ($config['pageno'] > 0))
{
    // check Page Number
    if (!isset($pageno))
    {
        $pageno = 1;
    }

	// define Max Results Per Page
	$maxresults = $config['pageno'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	
	
// get total amount of results from DB
	$totalresults = runSQL('SELECT count(*) AS num 
                              FROM '.TBL_PRIZELIST.' '.$WHERES);
 
// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
}
    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned




// do hard work
$SELECT = 'SELECT P.id_compet as id, P.id_club, P.id_season, C.imgurl, C.shortname, C.longname, S.season 
		   FROM '.TBL_PRIZELIST.' AS P
		   LEFT JOIN '.TBL_CLUBS.' AS C ON P.id_club = C.id
		   LEFT JOIN '.TBL_SEASONS.' AS S ON P.id_season = S.id
		   WHERE P.id_compet = '.$id.' ORDER BY S.season DESC'.$LIMIT;				 
$result = runSQL($SELECT);
$smarty->assign('number', count($result));

    // previous/next buttons
    $ids = $_SESSION['pcs']['query_result'];
    if (is_array($ids))
    {
        if (($key = array_search($id, $ids)) !== false)
        {
            $prev_id = ($key > 0) ? $ids[$key-1] : 0;
            $next_id = ($key < count($ids)-1) ? $ids[$key+1] : 0;
        }
    }

if (!$season) {$season = $config['seasonfilterdefault'];}
if ($config['competitionstats'] && $competition['active']) {
$smarty->assign('statsactive', 1);
}

$smarty->assign('season', $season);
$smarty->assign('haveseason', $season);
$smarty->assign('editable', $editable);
$smarty->assign('administrable', $administrable);
$smarty->assign('commentable', $commentable);
$smarty->assign('competition', $competition);
$smarty->assign('prev_id', $prev_id);
$smarty->assign('next_id', $next_id);
$smarty->assign('seegallery', $seegallery);
$smarty->assign('actiontitle', $lang['prizelist'] . ' ' . $competition['longname']);
//DISPLAY PAGE

// prepare
tpl_page('prizelist');
tpl_list($result);


// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    cache_start('index');
}

// allow XML and RSS export
if ($config['xls']) $smarty->assign('xls', 'index.php?');
if ($config['xml']) $smarty->assign('xml', 'index.php?');
if ($config['pdf']) $smarty->assign('pdf', 'index.php?');
if ($config['rss']) $smarty->assign('rss', 'index.php?');

// display templates
smarty_display('header.tpl');

if (!$config['http_caching']) flush();
smarty_display('actions_competitions.tpl', $id);
smarty_display('list_prizelist.tpl');
smarty_display('footer.tpl');

// caching enabled?
if ($config['httpcaching'])
{
    httpCacheOutput('prizelist'.$id, httpCacheCaptureEnd());
} 
?>