<?php
/**
 * Browse View
 *
 * 
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: index.php,v 1.00 2006/10/22 18:15:00
 */
 
require_once './core/session.php';
require_once './core/functions.php';
require_once './core/output.php';


// standard filters
	$filter_expr = array(
	  'NUM'  => '^["\\\' ]*[^A-Za-z]',  // simplified '^["\\\' ]*[^ABCabcDEFdefGHIghiJKLjklMNOmnoPQRSpqrsTUVtuvWXZwxy"\\\' ]',
	  'ABC'  => '^["\\\' ]*[ABCabc]',
	  'DEF'  => '^["\\\' ]*[DEFdef]',
	  'GHI'  => '^["\\\' ]*[GHIghi]',
	  'JKL'  => '^["\\\' ]*[JKLjkl]',
	  'MNO'  => '^["\\\' ]*[MNOmno]',
	  'PQRS' => '^["\\\' ]*[PQRSpqrs]',
	  'TUV'  => '^["\\\' ]*[TUVtuv]',
	  'WXYZ' => '^["\\\' ]*[WXZwxy]'
	);



if (!$q) {
	// SET DEFAULTS
	if (!isset($filter)) 
	{
		$filter       = $_SESSION['pcs']['personsfilter'];
		$countryfilter   = $_SESSION['pcs']['personscountryfilter'];
	
		if (!isset($filter)) 
		{
			$filter = $config['filterdefault'];
			$countryfilter = $config['countryfilterdefault'];
		}
	}
	
	$_SESSION['pcs']['personsfilter']  = $filter;
	$_SESSION['pcs']['personscountryfilter']  = $countryfilter;
	
	
	
	//Persons type, players by default
	if (!$type) {$type = 1;}
	
	if (!isset($countryfilter)) {
		$countryfilter   = $_SESSION['pcs']['personscountryfilter'];
		if (!isset($filter)) {
		$countryfilter = $config['countryfilterdefault'];
		}
	}
	
	// create SQL according to selected filter
	switch ($filter)
	{
		case 'all':
						$ORDER  = TBL_PERSONS.'.lastname';
						$WHERES = 'WHERE '.TBL_PERSONS.'.type='.$type;
						break;
		case 'full':
						$WHERES = 'WHERE 1=1 AND '.TBL_PERSONS.'.type='.$type;  // secret filter for exposing all data
						break;
		default:
						// make sure filter is valid
						if (!array_key_exists($filter, $filter_expr)) $filter = 'ABC';
						// apply filter
						$WHERES = 'WHERE '.TBL_PERSONS.'.lastname RLIKE \''.$filter_expr[$filter].'\' AND '.TBL_PERSONS.'.type='.$type;
	}
	
	if ($countryfilter) {
		if ($WHERES) {$WHERES .= ' AND ';}
		else {$WHERES .= ' WHERE ';}
		$WHERES .= TBL_PERSONS.'.country=\''.$countryfilter.'\'';
	}
}

//IF SEARCH ACTION
//DEFINE QUERY
// prepare search query
else {
require_once './core/queryparser.php';
$fields = array('firstname', 'lastname', 'plot');
//Persons type, players by default
if (!$type) {$type = 1;}
$QUERY = '';

	if (!empty($q))
	{
		$error  = '';
		$tokens = queryparser($q, $error);
		$wild_char = (empty($nowild)) ? '%' : '';

		foreach ($tokens as $token)
		{
            // escape search token
			$token['token'] = addslashes($token['token']);
            // concatenate tokens with token operator
			$QUERY .= $token['ops'].' (';
            // concatenate all searchable fields with OR
			foreach ($fields as $field) {
				$QUERY .= " ($field LIKE '$wild_char".$token['token']."$wild_char') OR ";
			}
			$QUERY .= ' 1=2)';
		}
	$WHERES = "WHERE 1=1 AND ".TBL_PERSONS.".type=".$type." ".$QUERY;
	
	}
$smarty->assign('q', $q); 
$ORDER   = TBL_PERSONS.'.lastname DESC, ' . TBL_PERSONS.'.firstname DESC';
}

// default order
if (!$ORDER)  {
	$ORDER   = TBL_PERSONS.'.lastname';
}

// This checks to see if user has selected the New items
// (This is seperately assigned as a LIMIT so, if this
// exists, lets just skip page numbers and carry on
if (!$LIMIT && ($config['pageno'] > 0))
{
    // check Page Number
    if (!isset($pageno))
    {
        $pageno = 1;
    }

	// define Max Results Per Page
	$maxresults = $config['pageno'];

	// define the Start Number
	$from = (($pageno * $maxresults) - $maxresults);
	
	
// get total amount of results from DB
	$totalresults = runSQL('SELECT count(*) AS num 
                              FROM '.TBL_PERSONS.' '.$WHERES);
 
// calculate Total amount of pages
	$totalpages = ceil($totalresults[0]['num'] / $maxresults);
	
	$LIMIT = ' LIMIT '.$from.', '.$maxresults;
}
    $smarty->assign('pageno', $pageno);                         // assign current Page Number
	$smarty->assign('maxpageno', $totalpages);		            // set Maximum Pages
	$smarty->assign('totalresults', $totalresults[0]['num']);   // set Total Records Returned


// do hard work
$select = 'SELECT id, lastname, firstname, imgurl FROM '.TBL_PERSONS.' '.$WHERES.' ORDER BY '.$ORDER.' '.$LIMIT;
$result = runSQL($select);

	$smarty->assign('number', count($result));
	
//echo $select;
//exit;

// store query result in session for prev/next navigation
$_SESSION['pcs']['query_result'] = array_map(create_function('&$row', 'return $row["id"];'), $result);

 

//DISPLAY PAGE



// prepare
tpl_page('persons');
tpl_list($result);
tpl_filters_persons($filter, $type, $countryfilter);

// caching enabled?
if ($config['http_caching'])
{
    require_once('./core/httpcache.php');
    cache_start('index');
}


// show more/less control in list view
$smarty->assign('moreless', true); 

// allow XML and RSS export
if ($config['xls']) $smarty->assign('xls', 'index.php?');
if ($config['xml']) $smarty->assign('xml', 'index.php?');
if ($config['pdf']) $smarty->assign('pdf', 'index.php?');
if ($config['rss']) $smarty->assign('rss', 'index.php?');

// display templates
smarty_display('header.tpl');
smarty_display('filters_persons.tpl');
if (!$config['http_caching']) flush();

smarty_display('list_persons.tpl');
smarty_display('footer.tpl');

// caching enabled?
if ($config['httpcaching'])
{
    httpCacheOutput('persons', httpCacheCaptureEnd());
} 
?>