<?
/**
 * Edit Page
 *
 * The edit form for managing category data
 *
 * @package PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: manage_competitions.php,v 1.00 2007/04/22 13:00:00
 */

require_once './core/functions.php';
require_once './core/security.php';

// check for localnet
localnet_or_die();

// multiuser permission check
permission_or_die(PERM_WRITE);
$noError = true;

// XML import
if ($config['xml'] && ($import == 'xml'))
{
    require_once './core/xml.php';

    // xml file upload
    if (isset($_FILES['xmlfile']) && is_uploaded_file($_FILES['xmlfile']['tmp_name']))
    {
        $file    = $_FILES['xmlfile']['tmp_name'];
        $xmldata = file_get_contents($file);
        unlink($file);
    }

    // uploading XML data directly or loaded from file
    if (!empty($xmldata))
    {
        $error      = '';
        $item_id    = 0;

        if (($xmlitems = xmlimport($xmldata, $error)) !== false)
        {
            // multiple items imported
            if ($xmlitems === true)
            {
                redirect('categories.php');
            }
            // exactly one competition imported?
            else
            {
                redirect('show_categories.php?id='.$xmlitems);
            }
        }
        $smarty->assign('xmlerror', $error);
    }

    // prepare templates
    tpl_page();

    // display templates
    tpl_display('xmlimport.tpl');
    exit;
}




// save data
if ($op == 'moveup') {
	if (!$parent) {$parent = '0';}
	if (!$pos) {$pos = '0';}
	$next = $pos+1;
	$SELECT = 'UPDATE  '.TBL_CATEGORIES.' SET  '.TBL_CATEGORIES.'.pos =  '.$next.' WHERE  '.TBL_CATEGORIES.'.parent = \''.$parent.'\' AND '.TBL_CATEGORIES.'.pos = '.$pos;
	runSQL($SELECT);
    $INSERT = 'UPDATE '.TBL_CATEGORIES.' SET pos = '.$pos.' WHERE id = '.$id;
    runSQL($INSERT);
    // show the saved competition
    redirect('manage_categories.php');
}
if ($op == 'movedown') {
	if (!$parent) {$parent = '0';}
	if (!$pos) {$pos = '0';}
	$prev = $pos-1;
	$SELECT = 'UPDATE  '.TBL_CATEGORIES.' SET  '.TBL_CATEGORIES.'.pos =  '.$prev.' WHERE  '.TBL_CATEGORIES.'.parent = \''.$parent.'\' AND '.TBL_CATEGORIES.'.pos = '.$pos;
	runSQL($SELECT);
    $INSERT = 'UPDATE '.TBL_CATEGORIES.' SET pos = '.$pos.' WHERE id = '.$id;
    runSQL($INSERT);
    // show the saved competition
    redirect('manage_categories.php');
}

// load existing data

    //$SELECT = 'SELECT id, longname, shortname, pos, parent FROM '.TBL_CATEGORIES.' WHERE parent = 0 ORDER BY parent, pos';
	//$categories = runSQL($SELECT);

	$cat_list = get_subcat_data(0, '');


	// multi-user permissions
    if ($config['multiuser'])
    {
		$smarty->assign('editable', check_permission(PERM_WRITE, $_COOKIE['PCSuserid']));
		if ($config['activecomments']) {
	    $smarty->assign('commentable', check_permission(PERM_MKCOMMENT, $_COOKIE['PCSuserid']));
		}
		if ($config['activegallery']) {
	    $smarty->assign('seegallery', check_permission(PERM_GALLERY, $_COOKIE['PCSuserid']));
		}
    }
	




// prepare templates
tpl_page();
tpl_manage_categories($cat_list);
$smarty->assign('lookup_id', $lookup);
$smarty->assign('http_error', $CLIENTERROR);
// allow XML import
if ($config['xml'] && empty($id)) $smarty->assign('xmlimport', true);
// display templates
tpl_display('manage_categories.tpl');	

// caching enabled?
if ($config['http_caching'])
{
    httpCacheOutput('edit_categories'.$id, httpCacheCaptureEnd());
}

?>
