<?php
/**
 * calendar page
 *
 * Display calendar for form page.
 *
 * @package Setup
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: lookup_calendar.php,v 1.00 2006/12/06 18:15:00
 */

require_once './core/functions.php';
require_once './core/template.php';




$smarty->assign('title',	htmlspecialchars($title));
$smarty->assign('header',	$header);
$smarty->assign('mymonth',	$mymonth);
$smarty->assign('style',	$config['style']);
$smarty->assign('langcode', $config['language']);
$smarty->assign('obj',	$obj);
$smarty->assign('calendar', showCalendar($p,$obj));


if (!$config['http_caching']) flush();
smarty_display('lookup_calendar.tpl');

 // Fonction pour afficher le calendrier
function showCalendar($periode, $object) {
global $lang;
		  if ($periode < 1) {
		  	$periode = date("dmY");
		  }
		  $mymonth = Array("", $lang['month01'], $lang['month02'], $lang['month03'], $lang['month04'], $lang['month05'], $lang['month06'], 
		  $lang['month07'], $lang['month08'], $lang['month09'], $lang['month10'], $lang['month11'], $lang['month12']);
		  
          $leCalendrier = '<table width="100%" border="0" cellspacing="0">';
          // Tableau des valeurs possibles pour un numro de jour dans la semaine
          $tableau = Array("0", "1", "2", "3", "4", "5", "6", "0");
		  // Definition des mois
		  
          $nb_jour = Date("t", mktime(0, 0, 0, getMonth($periode), 1, getYear($periode)));
          $pas = 0;
          $indexe = 1;

          // Affichage du mois et de l'anne
          //$leCalendrier .= '<tr><td colspan="7">&raquo; ' . monthNumToName(getMonth($periode)) . ' ' . getYear($periode) . '</td></tr>';
          $leCalendrier .= '<tr><td colspan="7">&raquo; ' . $lang['month'.getMonth($periode)] . ' ' . getYear($periode) . '</td></tr>';
          // Affichage des enttes
          $leCalendrier .= '
          <tr id="libelle">
          <td class="daycalendar" align="center">'.$lang['day1'].'</td>
          <td class="daycalendar" align="center">'.$lang['day2'].'</td>
          <td class="daycalendar" align="center">'.$lang['day3'].'</td>
          <td class="daycalendar" align="center">'.$lang['day4'].'</td>
          <td class="daycalendar" align="center">'.$lang['day5'].'</td>
          <td class="daycalendar" align="center">'.$lang['day6'].'</td>
          <td class="daycalendar" align="center">'.$lang['day0'].'</td>
          </tr>';
          // Tant que l'on n'a pas affect tous les jours du mois trait
          while ($pas < $nb_jour) {
               if ($indexe == 1) $leCalendrier .= '<tr class="ligne">';
               // Si le jour calendrier == jour de la semaine en cours
               if (Date("w", mktime(0, 0, 0, getMonth($periode), 1 + $pas, getYear($periode))) == $tableau[$indexe]) {
                    // Si jour calendrier == aujourd'hui
                    $afficheJour = Date("j", mktime(0, 0, 0, getMonth($periode), 1 + $pas, getYear($periode)));
                    if (Date("Y-m-d", mktime(0, 0, 0, getMonth($periode), 1 + $pas, getYear($periode))) == Date("Y-m-d")) {
                         $class = ' class="itemdate"';
                    }
                    else {
                         // 1 est toujours vrai => on affiche un lien  chaque fois
                         // A vous de faire les tests ncessaire si vous grer un agenda par exemple
                         if (1) {
						 	  $myday = Date("j", mktime(0, 0, 0, getMonth($periode), 1 + $pas, getYear($periode)));
							  if ($myday <= 9) {$myday = '0'.$myday;}
                              $class = ' class="itemdatexist"';
                              $afficheJour = '<a class="mydate" href="javascript:returnMyDate(\''.$myday.getMonth($periode).getYear($periode).'\')">' . $myday . '</a>';
                         }
                         else {
                              $class = "";
                         }
                    }
                    // Ajout de la case avec la date
                    $leCalendrier .= '<td'.$class.'>'.$afficheJour.'</td>';
                    $pas++;
               }
               //
               else {
                    // Ajout d'une case vide
                    $leCalendrier .= '<td class="itemdate">&nbsp;</td>';
               }
               if ($indexe == 7 && $pas < $nb_jour) { $leCalendrier .= '</tr>'; $indexe = 1;} else {$indexe++;}
          }
          // Ajustement du tableau
          for ($i = $indexe; $i <= 7; $i++) {
               $leCalendrier .= '<td>&nbsp;</td>';
          }
		  $leCalendrier .= '</tr><form name="calendar">';
		  $leCalendrier .= '<tr><td colspan="3">&nbsp;</td><td colspan="2" align="right"><select name="mymonth" onchange="lookupCalendar(\'01\' + document.calendar.mymonth.value + document.calendar.myyear.value,\''.$object.'\')">';
		  for ($x=1;$x<=12; $x++) {
		   if ($x<=9) {$m = '0'.$x;}
		   else {$m = $x;}
		   	if (getMonth($periode) == $m) {
		   	$leCalendrier .= '<option value="'.$m.'" selected>'.$mymonth[intval($m)].'</option>';
			}
			else {
			$leCalendrier .= '<option value="'.$m.'">'.$mymonth[intval($m)].'</option>';
			}
		  }
		  $leCalendrier .= '</select></td>';
		  $leCalendrier .= "<td colspan=\"2\"><select name=\"myyear\" onchange=\"lookupCalendar('01' + document.calendar.mymonth.value + document.calendar.myyear.value,'".$object."')\">";		   
			  for ($x=(getYear($periode)-10);$x<=(getYear($periode)+10); $x++) {
			  	if (getYear($periode) == $x) {
				$leCalendrier .= '<option value="'.$x.'" selected>'.$x.'</option>';
				}
				else {
				$leCalendrier .= '<option value="'.$x.'">'.$x.'</option>';
				}
			  }
		  $leCalendrier .= '</select></td></tr>';
          $leCalendrier .= '</tr></form></table>';

          // Retour de la chaine contenant le Calendrier
          return $leCalendrier;
}


// fonctions utiles, $valeur reprsente une date au format AAAA-MM-JJ
     function getSecond($valeur) {
          return substr($valeur, 17, 2);
     }

     function getMinute($valeur) {
          return substr($valeur, 14, 2);
     }

     function getHour($valeur) {
          return substr($valeur, 11, 2);
     }

     function getDay($valeur)     {
          return substr($valeur, 0, 2);
     }

     function getMonth($valeur)     {
          return substr($valeur, 2, 2);
     }

     function getYear($valeur) {
          return substr($valeur, 4, 4);
     }

     function monthNumToName($mois) {
          $tableau = Array("", $lang['month01'], $lang['month02'], $lang['month03'], $lang['month04'], $lang['month05'], $lang['month06'], 
		  $lang['month07'], $lang['month08'], $lang['month09'], $lang['month10'], $lang['month11'], $lang['month12']);
          return (intval($mois) > 0 && intval($mois) < 13) ? $tableau[intval($mois)] : "Indfini";
     }


?>
