<?php
/**
 * Installer
 *
 * Create database, tables and config file
 *
 * @package SetUp PHP Competition System
 * @author  Eric GALLENE <okrome@free.fr>
 * @link	http://www.phpcompet.com
 * @version $Id: install.php,v 1.30 2006/12/20 18:43:57 andig2 Exp $
 */

require_once './../core/compatibility.php';
require_once 'installfunctions.php';
require_once './../config.inc.php';
require_once './../core/constants.php';


// required files
$upgrade_file	= './doc/updatedb.sql';

// button definitions
$button_next    = '&nbsp;&nbsp; Next &nbsp;&nbsp;>>';
$button_prev    = '<<&nbsp;&nbsp; Previous &nbsp;&nbsp;';
$button_upgrade = 'Upgrade';


// extract request parameters and disable warnings
#error_reporting (E_ERROR + E_PARSE);
error_reporting (0);
extract($_REQUEST, EXTR_OVERWRITE);

// set default
$upgrading = false;

// stepping back?
if (isset($formPrevious))
{

    $step -= 2;
}

// upgrading?
elseif (isset($action) && stristr($action, 'upgrade'))
{
    $upgrading = true;

    // load configuration
    include_once(CONFIG_FILE);

    // begin of upgrade?
	if (empty($step))
    {
        // set initial step for upgrading
        $step = 2;

        // set default db configuration
        if (empty($db_server))
        {
            extract($config, EXTR_OVERWRITE, 'db_');
        }


        // remove files from previous version
        foreach(array(
            'functions.php',
            'setupfunctions.php', 'compatibility.php', 'template.php',
            'queryparser.php', 'genres.php', 'output.php',
            'session.php')
            as $file)
        {
            if (file_exists($file)) @rename($file, $file.'.old');
        }


        // remove old smarty cache
        delete_files('cache/smarty');
    }
}

// or first installation step?
elseif (empty($step))
{
    $step = 1;
	
	if (file_exists('install.lock')) {
		error("Le fichier Install.lock xiste dans le dossier d'installation.<br />Effacer ce fichier si vous souhaitez rinstaller.");
		$step = 10;
	}
}



?>

<html>
<head>
	<title>PHP Competition System - Installation</title>
	<link rel="stylesheet" href="stylesheet.css" type="text/css" />
<!--
	<script language="JavaScript" type="text/JavaScript">
	function validate_check()
    {
		if(!document.form1.backedup.checked) {
			alert("Please confirm you have backed up your Database by checking the checkbox");
			return false;
		} else {
			return true;
		}
	}
	</script>
-->
</head>

<body>
<!--
<table width="100%" height="100%">
<tr align="center" valign="middle"><td>
-->
<table width="960" cellspacing="0" cellpadding="0" border="0" align="center" bgcolor="white" style="margin-top: 40px">
<tr>
	<td colspan="4">
		<table width="100%" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td><img src="images/topbar.gif" width="588" height="37" border="0"></td>
				<td valign="bottom"><img src="images/logo.gif" width="372" height="26" border="0"></td>
			</tr>		
		</table>
	</td>
</tr>
<tr>
	<td id="left">&nbsp;</td>
	<td colspan="2">&nbsp;</td>
	<td id="right">&nbsp;</td>
</tr>
<tr>
	<td id="left">&nbsp;</td>
	<td colspan="2" class="tablemenu">Installation de <span class='logo'>PHP Competition System -- Etape : <?=$step?></span></td>
	<td id="right">&nbsp;</td>
</tr>
<tr>
	<td id="left">&nbsp;</td>
	<td colspan="2">
		<table>
		<tr><td>


<?


// no messages yet
$message = '';

// handle installation step
switch ($step)
{

    case 3:     /*
                 * database parameters have been collected, start actual installation
                 */

                // connect to database server
                $dbh = @mysql_connect($db_server, $db_user, $db_password);
				if (!$dbh) {
					error("Impossible de se connect: ".mysql_error(),1);
					$step--;
					break;
				}
				
				
				
                // check database existance
				if (mysql_select_db($db_database, $dbh))
                {
					error("Cette base xiste dj : ".$db_database,1);
				}
                else
                {
                    // database doesn't exist, create it
					info("Creation de la base de donnes...");

                    // try to create the database..
					if (!@mysql_query("CREATE DATABASE `".$db_database."`", $dbh))
                    {
						error("Impossible de crer la base de donnes : ".mysql_error($dbh),1);
						$step--;
						continue;
					}
                    else
                    {
                        // ..and select it
						if (!mysql_select_db($db_database, $dbh))
                        {
							error("Impossible de slectionner la base de donnes : ".mysql_error($dbh),1);
							$step--;
							continue;
						}
					}
				}
				
                // check if tables with this prefix already exist
                global $db_prefix;
				$rs = mysql_query("SHOW TABLES FROM `".$db_database."` LIKE '".$db_prefix."%'" ) or trigger_error("Can't execute: ".mysql_error($dbh), E_USER_ERROR);
				if (mysql_num_rows($rs) > 0)
                {
					error("La base de donnes possde dja des tables avec ce prefixe!");
					break;
				}

                // add root user warning
                if ($db_user == 'root')
                {
                    warn("Vous utilisez le user 'root' pour la connexion  votre base de donnes. Root est utilis comme user pour la super administration.
                          Pour des raisons de securit il est recommend de choisir un user diffrent aprs l'installation.");
                }
				
                // continue with table installation
				//$step++;
				break;
				

    case 4:     /*
                 * continue installation by upgrading or installing tables and (re)moving files (upgrade only)
                 */

                if ($upgrading)
                {
					// re-connect if not continued from step 3
					if (!isset($dbh))
                    {
						$dbh = @mysql_connect($db_server, $db_user, $db_password) or trigger_error("Impossible de se connecter : ".mysql_error(), E_USER_ERROR);
						mysql_select_db($db_database, $dbh) or trigger_error("Impossible de slectionner la base de donnes : ".mysql_error($dbh), E_USER_ERROR);
					}

					// get version
					$sql = "SELECT value FROM {$db_prefix}config WHERE opt = 'dbversion'";
					$rs = mysql_query($sql, $dbh);
					if ($rs) list($version) = mysql_fetch_row($rs);

                    // successfully retrieved installed version?
					if (!($rs && $version))
                    {
						error("Erreur sur la lecture de la version DB, tenter une installation complte plutot qu'un upgrade: ".mysql_error($dbh));
						error("<br/><br/><pre>$sql</pre>");
						$step--;
						break;
					}
					
                    // already correct db version? this might happen if just the username/ password were wrong
                    //if ($config['dbneeded'] == DB_REQUIRED)
                    //{
                    //   info("Aucune mise  jour de la base n'est requise.");
                    //    break;
                    //}

					// upgrade
					info("<br/>Mise a jour des tables...");
					info("Ancienne version de la base de donnes : $version");
					
					// perform actual upgrade
					$upgrades = parse_upgrades();
					if (empty($upgrades[$version+1]))
                    {
						error("Impossible de lire le numero de version.");					
						$step--;
						break;
					}
					else
                    {
						$sql_array = array();
						// select the relevant upgrades (> current version)
						foreach ($upgrades as $ver => $value)
                        {
							if ($ver > $version) $sql_array["$ver"] = $value;
						}

                        // upgrades successful?
                        $version = db_upgrade($sql_array);
						if (is_numeric($version))
                        {
                            info("Nouvelle version de la base de donnes : $version");
                        }
                        else
                        {
                            // error
                            $step--;
                        }
						// create install.lock
						info("<br/>Ecriture du fichier de vrrouillage...");
						$locked = array('install' => 'ok');

                        if (!file_put_contents('./install.lock', $locked))
                        {
                            error('<br/>Impossible d\'enregsitrer le fichier!<br/><br/>', 1);
						}
					}
				}
				else
				{
					// install
					info("<br/>Installing tables...");

					// re-connect if not continued from step 3
					if (!$dbh) {
						$dbh = @mysql_connect($db_server, $db_user, $db_password) or trigger_error("Impossible de se donnecter : ".mysql_error(), E_USER_ERROR);
						mysql_select_db($db_database, $dbh) or trigger_error("Impossible de slectionner la base : ".mysql_error($dbh), E_USER_ERROR);
					}

					// open SQL script from doc directory
					$sql = file_get_contents('doc/createtables.sql');
					if (!$sql) trigger_error('Impossible d\'ouvrir le fichier SQL : doc/createtables.sql', E_USER_ERROR);

                    if (runSQL($sql, $dbh) === false) {
						error('Erreur lors de la creation des tables: '.mysql_error($dbh));
						error('<br/><br/><pre>'.$sql.'</pre>');
						$step--;
					}
					else
                    {
						// create config file
						info("<br/>Ecriture du fichier de configuration...");
						$config = parse_config(array(
							'db_server'		=> $db_server,
							'db_user'		=> $db_user,
							'db_password'	=> $db_password,
                            'db_database'   => $db_database,
                            'db_prefix'     => $db_prefix), true);

                        if (!file_put_contents('../config.inc.php', $config))
                        {
                            error('<br/>Impossible d\'enregsitrer le fichier ../config.inc.php !
									   <br/>Assurez vous que votre fichier de configuration contienne au moins ces lignes :<br/><br/>'.
									   highlight_string($config, 1));
						}
						// create install.lock
						info("<br/>Ecriture du fichier de vrrouillage...");
						$locked = array('install' => 'ok');

                        if (!file_put_contents('./install.lock', $locked))
                        {
                            error('<br/>Impossible d\'enregsitrer le fichier!<br/><br/>', 1);
						}
					}
				}

				break;
				
}


// determine next installation step
switch ($step)
{

    case 4:     // start PHP Compet
                $action_target = '../index.php';
                break;
    default:    // continue installation
                $action_target = 'install_fr.php';
}


?>
            <form name='form1' method='post' action='<?=$action_target?>'>
            <table>
<?

if ($upgrading)
{

    echo "<input type='hidden' name='action' value='upgrade'/>";
}

switch ($step)
{
case 10:		// PHP Compet already installed


?>				<tr><td colspan="2">
                    <?=$message?>
					<b>Error</b><br/><br/>
					PHP Competition System est dja install sur votre serveur<br/>
					<br/>
                    
				</td></tr>

				<tr><td colspan="2">
					<input class="button" type="button" name="back" value="<< &nbsp;&nbsp; Retour" id="back" onClick="javascript:history.go(-1);"/>
				</td></tr>
<?				break;

	case 4:		// start PHP Compet
                $installed = ($upgrading) ? 'upgraded' : 'installed';

?>				<tr><td colspan="2">
                    <?=$message?>
					<b>Installation complte !</b><br/><br/>
					La base de donnes PHP Competition System database et ses tables ont t <?=$installed?> avec succs.<br/>
					<br/>
                    <?
                        // different settings than config file specified?
                        if (($db_server     != $config['db_server']) ||
                            ($db_database   != $config['db_database']) ||
                            ($db_user       != $config['db_user']) ||
                            ($db_password   != $config['db_password']) ||
                            ($db_prefix     != $config['db_prefix']))
                        {
                            warn('Vos user / mot de passe choisi pour l\'upgrade ne correspondent pas au fichier de configuration. Reconfigurez le fichier de configuration correstement.', true);
                        }

                        warn('Pour des raisons de securit,  le fichier (install.php) devrait tre ffac aprs l\'installation.
                              Vous pouvez plus tard diter vos paramtres dans le fichier '.CONFIG_FILE.'.', true);
                    ?>
					Cliquer sur <b>Start</b> pour commencer  utiliser le<b> PHP Competition System</b>...<br/>
					<br/>
				</td></tr>

				<tr><td colspan="2">
					<input type="hidden" name="step" value="<?=$step?>"/>
					<input class="button" type="submit" name="submit" value="Start &nbsp;&nbsp;>>" id="focus"/>
					<script language='JavaScript'>form1.focus.focus();</script>
				</td></tr>
<?				break;

	case 3:		// confirm installation if tables exist
                $install = ($upgrading) ? 'Installing' : 'Upgrading';
				
                if ($upgrading)
                {
?>
                    <tr><td colspan="2">
                        <br/><b><?=$install?> la base de donnes et les tables.</b><br/><br/>
                        <?=$message?>
                        <br/>
                    </td></tr>
<?
                } else {
?>
                    <tr><td colspan="2">
                        <br/><b><?=$install?> la base de donnes et les tables.</b><br/><br/>
                        <?=$message?>
                        Vous avez choisi une base de donnes <b>non-vide</b>. Effectuer une installion dans une base de donnes <b>non-vide</b> peut ffacer certaines donnes et n'est recommand que pour les utilisateurs expriments.
                        <br/>
                    </td></tr>

                    <tr><td colspan="2">
                        <br/>
                        Slectionnez <b>Upgrade</b> pour mettre  jour l'installation xistante (recommand).
                        Avant de mettre  jour pensez  faire une sauvegarde de votre base !<br/>
                        <br/>
                    </td></tr>

                    <tr><td colspan="2">
                        <input class="button" type="submit" name="action" value="<?=$button_upgrade?>" id="focus"/>
                        <br/>
                    </td></tr>

                    <tr><td colspan="2">
                        <br/>
                        Cliquer sur <b>Suivant</b> pour installer les tables dans la base de donnes...<br/>
                        <br/>
                    </td></tr>
<?
                }
?>
				<tr><td colspan="2">
					<input type="hidden" name="db_server" value="<?=$db_server?>"/>
					<input type="hidden" name="db_user" value="<?=$db_user?>"/>
					<input type="hidden" name="db_password" value="<?=$db_password?>"/>
					<input type="hidden" name="db_database" value="<?=$db_database?>"/>
					<input type="hidden" name="db_prefix" value="<?=$db_prefix?>"/>
					<input type="hidden" name="step" value="<?=$step+1?>"/>
					<input class="button" type="submit" name="formPrevious" value="<?=$button_prev?>"/>
					<input class="button" type="submit" name="submit" value="<?=$button_next?>"/>
					<script language='JavaScript'>form1.focus.focus();</script>
				</td></tr>
<?				break;

	case 2:		// get setup parameters
                $install = ($upgrading) ? 'upgrade' : 'install';

				if (empty($db_server))  $db_server	= 'localhost';
				if (empty($db_user))	$db_user	= 'root';
				if (empty($db_password)) $db_password = '';
				if (empty($db_database)) $db_database = 'phpcompetition';
				if (empty($db_prefix)) $db_prefix = 'pcs_';
?>
                <tr><td colspan="2">
<?
                    if ($upgrading)
                    {
                        // skip the database creation step
                        $step++;
?>
                        <br/><b>Upgrade de la base de donnes :</b><br/>
                        <br/>Votre base de donnes ne correspond pas  la dernire version de PHP Competition System. Votre systme a besoin d'une mise  jour..<br/>
                        <br/>
                        <? warn("Pensez  faire une sauvegarde de votre base !", true); ?>
                        <b>Selectionner une base de donnes et un user.</b><br/>
                        <br/>
<?
                    } else {
?>
                        <br/><b>Selectionner une base de donnes et un user.</b><br/>
                        <br/>
                        <b>Note:</b> Si vous n'installez pas dans une base de donnes xistante, assurez vous d'avoir les droits pour utiliser la commande <b>'Create Database'</b>.
                        <br/><br/>
<?
                    }
?>
                    <?=$message?>
				</td></tr>

				<tr><td>Serveur :</td><td><input type="text" name="db_server" value="<?=$db_server?>" id="focus"/></td></tr>
				<tr><td>User :</td><td><input type="text" name="db_user" value="<?=$db_user?>"/></td></tr>
				<tr><td>Mot de passe :</td><td><input type="password" name="db_password" value="<?=$db_password?>"/></td></tr>
                <tr><td>Base de donnes :</td><td><input type="text" name="db_database" value="<?=$db_database?>"/></td></tr>
                <tr><td>Prfixe de table :</td><td><input type="text" name="db_prefix" value="<?=$db_prefix?>"/> (only required for new installations)</td></tr>

				<tr><td colspan="2">
					<br/>
                    Cliquer sur <b>Suivant</b> pour <?=$install?> la base de donnes et les tables...<br/>
					<br/>
				</td></tr>

				<tr><td colspan="2">
					<input type="hidden" name="step" value="<?=$step+1?>"/>
					<input class="button" type="submit" name="formPrevious" value="<?=$button_prev?>"/>
					<input class="button" type="submit" name="submit" value="<?=$button_next?>"/>
					<script language='JavaScript'>form1.focus.focus();form1.focus.select();</script>
				</td></tr>
<?				break;

	case 1:		
	default:	// start setup

?>				<tr><td colspan="2">
					<br/>Bienvenue sur l'installation du <span style="font-weight:bold;"><a style="color:#333399" href="http://phpcompet.free.fr">PHP Competition System</a></span>. Pour cela il vous :
					<ol>
						<li><b>PHP &gt;= 4.2.0</b> avec la librairie GD et le support de session configur sur le serveur.</li><br/><br/>
						<li>Une <b>Base de donnes MySQL</b>, avec un login (user et mot de passe) capable de crer/ffacer les tables.</li><br/><br/>
						<li>Si vous souhaitez que l'installeur crer le fichier de configuration pour vous, il vous faut les droits en criture dans le <b>rpertoire d'installation</b> du PHP Competition System .</li><br/><br/>
					</ol>
					Cet installeur va crer la base de donnes sur votre serveur MySQL, crer les diffrentes tables, et generer le fichier de configuration du PHP Competition System.<br/><br/>

					Cliquer sur <b>Suivant</b> pour configurer la connexion  la base de donnes...<br/><br/>

					<input type="hidden" name="step" value="<?=$step+1?>"/>
					<input class="button" type="submit" name="submit" value="<?=$button_next?>" id="focus"/>
					<script language='JavaScript'>form1.focus.focus();</script>
				</td></tr>
<?
}

?>
            </table>
            </form>

			<br/><font size="1" color="#CCCCCC">Step: <?=$step?></font>
		</td>
		</tr>
		</table>
	</td>
	<td id="right">&nbsp;</td>
</tr>
<tr>
	<td id="left">&nbsp;</td>
	<td colspan="2">
		<table width="100%" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td align="center" valign="middle"><a href="http://www.mysql.com" target="_blank"><img src="../images/mysql.gif" width="100" height="52" border="0"></a></td>
				<td align="center" valign="middle"><a href="http://smarty.php.net" target="_blank"><img src="../images/smarty.gif" width="88" height="31" border="0"></a></td>
				<td align="center" valign="middle"><a href="http://www.php.net" target="_blank"><img src="../images/php.gif" width="69" height="36" border="0"></a></td>
			</tr>		
		</table>
	</td>
	<td id="right">&nbsp;</td>
</tr>
<tr>
	<td colspan="4">
		<table width="100%" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td valign="top"><img src="images/bottomlogo.gif" width="372" height="26" border="0"></td>
				<td><img src="images/bottombar.gif" width="588" height="37" border="0"></td>
			</tr>		
		</table>
	</td>
</tr>

</table>

</body>
</html>
